/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.util;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2856;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import work.lclpnet.kibu.translate.Translations;
import work.lclpnet.kibu.translate.text.RootText;
import work.lclpnet.notica.config.ConfigAccess;
import work.lclpnet.notica.impl.NoticaImpl;
import work.lclpnet.notica.util.PlayerConfigContainer;

public class NoticaServerPackManager {
    private final ConfigAccess configAccess;
    private final Translations translations;
    private final Logger logger;
    private final Set<UUID> requesting = new HashSet<UUID>();
    private final Set<UUID> installed = new HashSet<UUID>();
    private UUID packUuid = null;

    public NoticaServerPackManager(ConfigAccess configAccess, Translations translations, Logger logger) {
        this.configAccess = configAccess;
        this.translations = translations;
        this.logger = logger;
    }

    public void sendServerPack(class_3222 player) {
        UUID playerUuid = player.method_5667();
        if (this.installed.contains(playerUuid) || !this.requesting.add(playerUuid)) {
            return;
        }
        URL url = this.configAccess.getConfig().extraNotesPackUrl;
        if (url == null) {
            this.sendError(player);
            return;
        }
        String urlString = url.toString();
        UUID packUuid = UUID.nameUUIDFromBytes(urlString.getBytes(StandardCharsets.UTF_8));
        RootText prompt = this.translations.translateText(player, "notica.music.server_pack_prompt", new Object[0]).formatted(class_124.field_1060);
        class_2720 packet = new class_2720(packUuid, urlString, "", false, Optional.of(prompt));
        this.packUuid = packUuid;
        player.field_13987.method_14364((class_2596)packet);
    }

    public boolean hasServerPackInstalled(class_3222 player) {
        return this.installed.contains(player.method_5667());
    }

    public void onPlayerQuit(class_3222 player) {
        UUID uuid = player.method_5667();
        this.requesting.remove(uuid);
        this.installed.remove(uuid);
    }

    public void onResourcePackStatus(class_3222 player, class_2856 packet) {
        if (this.packUuid == null || !this.packUuid.equals(packet.comp_2163())) {
            return;
        }
        class_2856.class_2857 status = packet.comp_2164();
        this.logger.debug("Player {} sent server resource pack status {}", (Object)player.method_5820(), (Object)status);
        switch (status) {
            case field_13017: {
                this.onSuccess(player);
                break;
            }
            case field_13018: 
            case field_13015: 
            case field_47668: 
            case field_47667: 
            case field_47669: {
                this.onFail(player);
                break;
            }
        }
    }

    private void onSuccess(class_3222 player) {
        UUID uuid = player.method_5667();
        this.installed.add(uuid);
        this.requesting.remove(uuid);
        NoticaImpl instance = NoticaImpl.getInstance(player.method_51469().method_8503());
        PlayerConfigContainer configs = instance.getPlayerConfigs();
        configs.get(player).setExtendedRangeSupported(true);
        RootText msg = this.translations.translateText(player, "notica.music.server_pack_success", new Object[0]).formatted(class_124.field_1060);
        player.method_64398((class_2561)msg);
    }

    private void onFail(class_3222 player) {
        UUID uuid = player.method_5667();
        this.installed.remove(uuid);
        this.requesting.remove(uuid);
        NoticaImpl instance = NoticaImpl.getInstance(player.method_51469().method_8503());
        PlayerConfigContainer configs = instance.getPlayerConfigs();
        configs.get(player).setExtendedRangeSupported(false);
        this.sendError(player);
    }

    private void sendError(class_3222 player) {
        RootText msg = this.translations.translateText(player, "notica.music.server_pack_failed", new Object[0]).formatted(class_124.field_1061);
        player.method_64398((class_2561)msg);
    }

    public boolean isEnabled() {
        return this.configAccess.getConfig().extraNotesPackUrl != null;
    }
}

