/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import work.lclpnet.notica.util.PlayerConfigEntry;

public class PlayerConfigContainer {
    private final Path directory;
    private final Logger logger;
    private final Map<UUID, PlayerConfigEntry> entries = Collections.synchronizedMap(new HashMap());

    public PlayerConfigContainer(Path directory, Logger logger) {
        this.directory = directory;
        this.logger = logger;
    }

    @NotNull
    public PlayerConfigEntry get(class_3222 player) {
        return this.entries.computeIfAbsent(player.method_5667(), p -> new PlayerConfigEntry());
    }

    public void onPlayerJoin(class_3222 player) {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return this.loadConfigNbt(player);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }).exceptionally(error -> {
            this.logger.error("Failed to load player config", error);
            return null;
        })).thenAccept(nbt -> {
            if (nbt == null) {
                return;
            }
            this.loadConfig(player, (class_2487)nbt);
            this.logger.debug("Restored player config of {}", (Object)player.method_5667());
        });
    }

    public void onPlayerQuit(class_3222 player) {
        PlayerConfigEntry config = this.entries.remove(player.method_5667());
        if (config == null) {
            return;
        }
        this.saveConfigAsync(player, config);
    }

    public void saveConfig(class_3222 player) {
        PlayerConfigEntry config = this.get(player);
        this.saveConfigAsync(player, config);
    }

    private void saveConfigAsync(class_3222 player, PlayerConfigEntry config) {
        CompletableFuture.runAsync(() -> {
            try {
                this.saveConfig(player, config);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }).whenComplete((res, err) -> {
            if (err != null) {
                this.logger.error("Failed to save player config", err);
            } else {
                this.logger.debug("Wrote player config of {}", (Object)player.method_5667());
            }
        });
    }

    private class_2487 loadConfigNbt(class_3222 player) throws IOException {
        Path path = this.getPath(player);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            class_2487 class_24872 = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53899((long)16384L));
            return class_24872;
        }
    }

    private void saveConfigNbt(class_3222 player, class_2487 nbt) throws IOException {
        Path path = this.getPath(player);
        Path dir = path.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            class_2507.method_10634((class_2487)nbt, (OutputStream)out);
        }
    }

    private void loadConfig(class_3222 player, class_2487 rootNbt) {
        PlayerConfigEntry config = this.get(player);
        config.readNbt(rootNbt);
    }

    private void saveConfig(class_3222 player, PlayerConfigEntry config) throws IOException {
        if (!config.isDirty()) {
            return;
        }
        class_2487 rootNbt = new class_2487();
        config.writeNbt(rootNbt);
        config.markClean();
        this.saveConfigNbt(player, rootNbt);
    }

    private Path getPath(class_3222 player) {
        UUID uuid = player.method_5667();
        return this.directory.resolve(uuid.toString() + ".dat");
    }
}

