/*
 * Decompiled with CFR 0.152.
 */
package org.A3rial.ultraRules;

import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.A3rial.ultraRules.MYSQLRULESLOCALHOST;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UltraRules
extends JavaPlugin
implements Listener {
    private static UltraRules instance;
    private final LegacyComponentSerializer legacy = LegacyComponentSerializer.legacyAmpersand();

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        if (this.getCommand("rules") != null) {
            this.getCommand("rules").setExecutor((CommandExecutor)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new MYSQLRULESLOCALHOST(this);
    }

    public void onDisable() {
        instance = null;
    }

    public static UltraRules getInstance() {
        return instance;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("ultrarules.reload")) {
                sender.sendMessage((Component)Component.text((String)"You don't have permission to do that.", (TextColor)NamedTextColor.RED));
                return true;
            }
            long start = System.currentTimeMillis();
            this.reloadConfig();
            long elapsed = System.currentTimeMillis() - start;
            sender.sendMessage((Component)Component.text((String)("UltraRules reloaded in " + elapsed + "ms."), (TextColor)NamedTextColor.GREEN));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Only players can open the rules GUI.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        this.openRulesGUI(player);
        return true;
    }

    private void openRulesGUI(Player player) {
        FileConfiguration config = this.getConfig();
        String titleRaw = config.getString("gui.title", "&a&lRules");
        Component title = this.parse(titleRaw);
        int size = config.getInt("gui.size", 27);
        Inventory gui = Bukkit.createInventory(null, (int)size, (Component)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        if (fillerMeta != null) {
            fillerMeta.displayName(this.parse("&7 "));
            filler.setItemMeta(fillerMeta);
        }
        for (int i = 0; i < size; ++i) {
            gui.setItem(i, filler);
        }
        List books = config.getMapList("gui.books");
        for (Map bookData : books) {
            int slot = this.getInt(bookData, "slot", 0);
            String name = this.getString(bookData, "name", "&bBook");
            List<String> lore = this.getStringList(bookData, "lore");
            ItemStack book = new ItemStack(Material.KNOWLEDGE_BOOK);
            ItemMeta meta = book.getItemMeta();
            if (meta != null) {
                meta.displayName(this.parse(name));
                meta.lore(lore.stream().map(this::parse).toList());
                book.setItemMeta(meta);
            }
            if (slot < 0 || slot >= size) continue;
            gui.setItem(slot, book);
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView() == null) {
            return;
        }
        String titleRaw = this.getConfig().getString("gui.title", "&a&lRules");
        Component guiTitle = this.parse(titleRaw);
        if (!event.getView().title().equals((Object)guiTitle)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        if (clicked.getType() == Material.GRAY_STAINED_GLASS_PANE) {
            event.setCancelled(true);
            return;
        }
        if (clicked.getType() != Material.KNOWLEDGE_BOOK) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        boolean playSound = this.getConfig().getBoolean("gui.sound-on", true);
        if (playSound) {
            String soundName = this.getConfig().getString("gui.Sound", "entity.experience_orb.pickup");
            Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)soundName.toLowerCase().replace(" ", "_")));
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            } else {
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }
        boolean closeOnClick = this.getConfig().getBoolean("gui.close-on-click", true);
        List books = this.getConfig().getMapList("gui.books");
        int slotClicked = event.getSlot();
        for (Map bookData : books) {
            int slot = this.getInt(bookData, "slot", -1);
            if (slot != slotClicked) continue;
            String cmd = this.getString(bookData, "command", "discord");
            if (cmd.startsWith("/")) {
                cmd = cmd.substring(1);
            }
            Bukkit.dispatchCommand((CommandSender)player, (String)cmd);
            if (!closeOnClick) break;
            player.closeInventory();
            break;
        }
    }

    private int getInt(Map<?, ?> map, String key, int def) {
        Object value = map.get(key);
        return value instanceof Number ? ((Number)value).intValue() : def;
    }

    private String getString(Map<?, ?> map, String key, String def) {
        Object value = map.get(key);
        return value instanceof String ? (String)value : def;
    }

    private List<String> getStringList(Map<?, ?> map, String key) {
        Object value = map.get(key);
        if (value instanceof List) {
            return ((List)value).stream().filter(e -> e instanceof String).map(e -> (String)e).toList();
        }
        return List.of();
    }

    private Component parse(String input) {
        if (input == null) {
            return Component.empty();
        }
        return this.legacy.deserialize(input);
    }
}

