/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.ruler;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.iafenvoy.ruler.TheRuler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public enum GameRuleConfig implements ResourceManagerReloadListener
{
    INSTANCE;

    private static final String PATH = "./config/the_ruler.json";
    private JsonObject gameRuleMap = null;

    public void onResourceManagerReload(ResourceManager manager) {
        try {
            FileInputStream stream = new FileInputStream(PATH);
            InputStreamReader reader = new InputStreamReader(stream);
            this.gameRuleMap = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (IOException e) {
            TheRuler.LOGGER.error("Failed to read file {}", (Object)PATH, (Object)e);
            try {
                FileUtils.write((File)new File(PATH), (CharSequence)"{}", (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                TheRuler.LOGGER.error("Failed to write file {}", (Object)PATH, (Object)ex);
            }
            this.gameRuleMap = new JsonObject();
        }
    }

    @Nullable
    public JsonPrimitive getData(String key) {
        if (this.gameRuleMap == null) {
            this.onResourceManagerReload(null);
        }
        try {
            if (this.gameRuleMap.has(key)) {
                return this.gameRuleMap.getAsJsonPrimitive(key);
            }
        }
        catch (Exception e) {
            TheRuler.LOGGER.error("Cannot read key {}", (Object)key, (Object)e);
        }
        return null;
    }
}

