/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.DifficultyFeatures;
import io.github.flemmli97.improvedmobs.api.datapack.EntityConfigProperties;
import io.github.flemmli97.improvedmobs.common.datapack.DifficultyAttributeConfig;
import io.github.flemmli97.improvedmobs.common.datapack.SingleFileResources;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class EntityOverridesManager
extends class_4309 {
    public static final class_2960 ID = ImprovedMobs.modRes("entity_configs");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private static EntityOverridesManager INSTANCE;
    private final class_7225.class_7874 provider;
    private Set<EntityConfigProperties> unresolved = ImmutableSet.of();
    private boolean resolved;
    private Map<class_1299<?>, EntityConfigProperties> properties = ImmutableMap.of();

    private EntityOverridesManager(class_7225.class_7874 provider) {
        super(SingleFileResources.GSON, DIRECTORY);
        this.provider = provider;
    }

    public static EntityOverridesManager create(class_7225.class_7874 provider) {
        INSTANCE = new EntityOverridesManager(provider);
        return EntityOverridesManager.getInstance();
    }

    public static EntityOverridesManager getInstance() {
        return INSTANCE;
    }

    public void applyAttributesTo(class_1309 entity, VariableMap map) {
        this.resolve();
        EntityConfigProperties properties = this.properties.get(entity.method_5864());
        if (properties != null) {
            if (properties.attributes().replace()) {
                properties.attributes().val().apply(entity, map, null);
            } else {
                DifficultyAttributeConfig.getInstance().config().apply(entity, map, properties.attributes().val());
            }
        } else {
            DifficultyAttributeConfig.getInstance().config().apply(entity, map, null);
        }
    }

    public OverrideState isEnabled(class_1309 entity, DifficultyFeatures feature) {
        this.resolve();
        EntityConfigProperties properties = this.properties.get(entity.method_5864());
        if (properties == null || properties.enabledFeatures().isEmpty()) {
            return OverrideState.DEFAULT;
        }
        EnumSet<DifficultyFeatures> set = properties.enabledFeatures().get();
        return set.contains((Object)DifficultyFeatures.REVERSE) ^ (set.contains((Object)DifficultyFeatures.ALL) || set.contains((Object)feature)) ? OverrideState.ALLOW : OverrideState.DENY;
    }

    public OverrideState canBreak(class_1309 entity, class_2680 state) {
        this.resolve();
        EntityConfigProperties properties = this.properties.get(entity.method_5864());
        if (properties == null) {
            return OverrideState.DEFAULT;
        }
        if (properties.breakableBlocks().val().method_40241(state.method_41520())) {
            return OverrideState.ALLOW;
        }
        return properties.breakableBlocks().replace() ? OverrideState.DENY : OverrideState.DEFAULT;
    }

    public void resolve() {
        if (!this.resolved) {
            this.resolved = true;
            HashMap direct = new HashMap();
            HashMap<class_1299, EntityConfigProperties> tags = new HashMap<class_1299, EntityConfigProperties>();
            HashMap<class_1299, EntityConfigProperties> namespace = new HashMap<class_1299, EntityConfigProperties>();
            class_7923.field_41177.method_40270().forEach(type -> this.unresolved.forEach(props -> {
                if (props.type().isDirect((class_6880<class_1299<?>>)type)) {
                    direct.put((class_1299)type.comp_349(), props);
                }
                if (props.type().isTag((class_6880<class_1299<?>>)type)) {
                    tags.put((class_1299)type.comp_349(), (EntityConfigProperties)props);
                }
                if (props.type().isNamespace((class_6880<class_1299<?>>)type)) {
                    namespace.put((class_1299)type.comp_349(), (EntityConfigProperties)props);
                }
            }));
            tags.forEach((type, prop) -> {
                if (!direct.containsKey(type)) {
                    direct.put(type, prop);
                }
            });
            namespace.forEach((type, prop) -> {
                if (!direct.containsKey(type)) {
                    direct.put(type, prop);
                }
            });
            this.properties = ImmutableMap.copyOf(direct);
        }
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        this.resolved = false;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        class_6903 ops = this.provider.method_57093((DynamicOps)JsonOps.INSTANCE);
        HashSet overrides = new HashSet();
        data.forEach((arg_0, arg_1) -> EntityOverridesManager.lambda$apply$4(builder, (DynamicOps)ops, overrides, arg_0, arg_1));
        if (!overrides.isEmpty()) {
            ImprovedMobs.LOGGER.info("Following entity overrides are loaded: {}", overrides);
        }
        this.unresolved = builder.build();
    }

    private static /* synthetic */ void lambda$apply$4(ImmutableSet.Builder builder, DynamicOps ops, Set overrides, class_2960 res, JsonElement element) {
        try {
            builder.add((Object)((EntityConfigProperties)EntityConfigProperties.CODEC.parse(ops, (Object)element).getOrThrow()));
            overrides.add(res);
        }
        catch (Exception ex) {
            ImprovedMobs.LOGGER.error("Couldn't parse entity config json {} {}", (Object)res, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }

    public static enum OverrideState {
        DEFAULT,
        ALLOW,
        DENY;

    }
}

