/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.equipment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.datapack.ItemUseLookupManager;
import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import io.github.flemmli97.improvedmobs.common.config.equipment.OptionalItemStack;
import io.github.flemmli97.improvedmobs.common.config.equipment.WeightedItemstack;
import io.github.flemmli97.improvedmobs.common.config.equipment.WeightedItemstackList;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1766;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3518;
import net.minecraft.class_4537;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9334;

public class EquipmentList {
    private static final int CONFIG_VERSION = 2;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Codec<Map<class_1304, WeightedItemstackList>> CODEC = Codec.unboundedMap((Codec)CodecUtils.stringEnumCodec(class_1304.class, null), WeightedItemstackList.CODEC).xmap(EnumMap::new, m -> m);
    private static Map<class_1304, WeightedItemstackList> EQUIPMENTS = new EnumMap<class_1304, WeightedItemstackList>(class_1304.class);

    public static class_1799 getEquipment(class_1308 mob, class_1304 slot, double difficulty) {
        WeightedItemstackList eq = EQUIPMENTS.get(slot);
        if (eq == null) {
            return class_1799.field_8037;
        }
        return eq.getRandomStack(mob.method_59922(), difficulty);
    }

    public static void initEquip(class_7225.class_7874 provider, ItemUseLookupManager manager) {
        try {
            Path path = CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json");
            class_6903 ops = provider.method_57093((DynamicOps)JsonOps.INSTANCE);
            if (!Files.exists(path, new LinkOption[0])) {
                EquipmentList.initDefaultVals(manager);
                Files.createFile(path, new FileAttribute[0]);
            } else {
                BufferedReader reader = Files.newBufferedReader(path);
                JsonObject config = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (config == null) {
                    config = new JsonObject();
                }
                reader.close();
                int version = class_3518.method_15282((JsonObject)config, (String)"version", (int)1);
                if (version < 2) {
                    ImprovedMobs.LOGGER.debug("You are having a legacy config. A Backup will be created");
                    EquipmentList.createBackup(manager);
                } else {
                    EQUIPMENTS = (Map)CODEC.parse((DynamicOps)ops, (Object)config).getPartialOrThrow();
                }
            }
            JsonObject updated = new JsonObject();
            updated.addProperty("version", (Number)2);
            updated.add("__comment", (JsonElement)EquipmentList.commentObj());
            JsonElement data = (JsonElement)CODEC.encodeStart((DynamicOps)ops, EQUIPMENTS).getOrThrow();
            if (data.isJsonObject()) {
                data.getAsJsonObject().entrySet().forEach(e -> updated.add((String)e.getKey(), (JsonElement)e.getValue()));
            }
            JsonWriter wr = GSON.newJsonWriter((Writer)Files.newBufferedWriter(path, StandardOpenOption.TRUNCATE_EXISTING));
            GSON.toJson((Object)updated, JsonObject.class, wr);
            wr.close();
        }
        catch (IOException | IllegalStateException e2) {
            ImprovedMobs.LOGGER.error("Error initializing equipment file", (Throwable)e2);
        }
    }

    private static JsonArray commentObj() {
        JsonArray comment = new JsonArray();
        comment.add("Mobs will be able to equip items declared here");
        comment.add("Value is the item. It also accepts item components. The default config has an example with a harming potion");
        comment.add("Weight is the weight of an item. Higher weight means that the item is more likely to get choosen");
        comment.add("Quality is a modifier applied to the weight. The final weight used is weight + quality * current difficulty");
        return comment;
    }

    private static void createBackup(ItemUseLookupManager manager) {
        try {
            Files.move(CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json"), CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json.bak"), new CopyOption[0]);
            EquipmentList.initDefaultVals(manager);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initDefaultVals(ItemUseLookupManager manager) {
        EQUIPMENTS = new EnumMap<class_1304, WeightedItemstackList>(class_1304.class);
        HashMap inverseWeight = new HashMap();
        class_7923.field_41178.method_40270().forEach(holder -> {
            class_5151 equipable;
            ItemUseHandler ai;
            class_1304 slot = null;
            class_1792 item = (class_1792)holder.comp_349();
            if (item instanceof class_1753) {
                slot = class_1304.field_6173;
            }
            if ((ai = (ItemUseHandler)manager.get(item).stream().findFirst().orElse(null)) != null) {
                slot = ai.defaultedSlot();
            }
            if (item instanceof class_5151 && (equipable = (class_5151)item).method_7685().method_5925() != class_1304.class_1305.field_48825) {
                slot = equipable.method_7685();
            }
            if ((item instanceof class_1829 || item instanceof class_1766) && !EquipmentList.defaultBlackLists(item)) {
                slot = class_1304.field_6173;
            }
            if (slot != null) {
                OptionalItemStack stack = item instanceof class_4537 ? new OptionalItemStack((class_6880.class_6883<class_1792>)holder, m -> m.method_57854(class_9334.field_49651, (Object)new class_1844(class_1847.field_9004))) : new OptionalItemStack((class_6880.class_6883<class_1792>)holder);
                inverseWeight.computeIfAbsent(slot, k -> new ArrayList()).add(Pair.of((Object)EquipmentList.score(item), (Object)stack));
            }
        });
        for (Map.Entry entry : inverseWeight.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            List<Pair> sorted = ((List)entry.getValue()).stream().sorted(Comparator.comparingInt(Pair::getFirst)).toList();
            int total = ((List)entry.getValue()).stream().mapToInt(Pair::getFirst).sum();
            float max = 1.0f / (float)((Integer)sorted.getFirst().getFirst()).intValue() * (float)total;
            float median = 1.0f / (float)((Integer)sorted.get((int)((double)sorted.size() * 0.5)).getFirst()).intValue() * (float)total;
            WeightedItemstackList list = new WeightedItemstackList(((List)entry.getValue()).stream().map(p -> {
                float[] normalized = EquipmentList.normalizeAndInvertWeight((Integer)p.getFirst(), max, median, total);
                return new WeightedItemstack((OptionalItemStack)p.getSecond(), (int)normalized[0], normalized[1]);
            }).toList());
            EQUIPMENTS.put((class_1304)entry.getKey(), list);
        }
    }

    private static float[] normalizeAndInvertWeight(int score, float max, float median, int total) {
        float weight = 1.0f / (float)score * (float)total;
        float quality = (max - weight) / (median * 1.5f) + 0.5f;
        return new float[]{Math.round(weight * 100.0f), quality * quality};
    }

    private static boolean defaultBlackLists(class_1792 item) {
        if (item instanceof class_1766 && !(item instanceof class_1743)) {
            return true;
        }
        return class_7923.field_41178.method_10221((Object)item).method_12836().equals("mobbattle");
    }

    private static int score(class_1792 item) {
        double score = 0.0;
        int durability = (Integer)item.method_57347().method_57830(class_9334.field_50072, (Object)0);
        class_1799 stack = new class_1799((class_1935)item);
        double damage = ItemUtils.attribute((class_1799)stack, (class_6880)class_5134.field_23721, (double)1.0, (class_9274[])class_9274.values());
        double armor = ItemUtils.attribute((class_1799)stack, (class_6880)class_5134.field_23724, (double)1.0, (class_9274[])class_9274.values());
        double toughness = ItemUtils.attribute((class_1799)stack, (class_6880)class_5134.field_23725, (double)1.0, (class_9274[])class_9274.values());
        double knockbackResistance = ItemUtils.attribute((class_1799)stack, (class_6880)class_5134.field_23718, (double)1.0, (class_9274[])class_9274.values());
        int enchantability = item.method_7837();
        double multiplier = 1.0;
        if (item.method_57347().method_57832(class_9334.field_49630)) {
            multiplier *= 2.5;
        }
        if ((armor > 1.0 || damage > 1.0) && durability <= 0) {
            durability = 1000;
        }
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            try {
                multiplier *= !((class_1856)((class_1741)armorItem.method_7686().comp_349()).comp_2301().get()).method_8103() ? 1.1 : 1.0;
            }
            catch (Exception e) {
                ImprovedMobs.LOGGER.error("Cannot compute repair ingredient {}", (Object)class_7923.field_41178.method_10221((Object)item), (Object)e);
            }
            multiplier *= armorItem.method_7686() == class_1740.field_7897 || armorItem.method_7686() == class_1740.field_7895 || armorItem.method_7686() == class_1740.field_7887 || armorItem.method_7686() == class_1740.field_7892 || armorItem.method_7686() == class_1740.field_7889 || armorItem.method_7686() == class_1740.field_21977 || armorItem.method_7686() == class_1740.field_7890 ? 1.2 : 1.0;
        } else if (item == class_1802.field_8884) {
            score = 800.0;
        } else if (item instanceof class_1819) {
            score = 1200.0;
        } else if (item instanceof class_1753) {
            class_1753 bow = (class_1753)item;
            score = 1000 + bow.method_24792() * 15;
        } else if (item instanceof class_1835) {
            multiplier *= 1.1;
        } else if (item instanceof class_1764) {
            class_1764 crossbow = (class_1764)item;
            score = 1000 + crossbow.method_24792() * 15;
        } else if (item instanceof class_1787) {
            score = 900.0;
        } else if (item == class_1802.field_8187) {
            score = 2200.0;
        } else if (item == class_1802.field_8634) {
            score = 1800.0;
        } else if (item == class_1802.field_8543) {
            score = 500.0;
        } else if (item instanceof class_4537) {
            score = 1500.0;
        } else if (item == class_1802.field_8598) {
            score = 1900.0;
        } else if (item == class_2246.field_10375.method_8389()) {
            score = 2200.0;
        }
        score += Math.sqrt(durability) * 15.0;
        score += Math.max(0.0, EquipmentList.step(damage, new Step(10.0, v -> (v * v * v * 3.0 - v * 5.0) * 2.5), new Step(40.0, v -> v * v * 8.0 + v * 5.0 + Math.sqrt(v * 50.0)), new Step(Double.MAX_VALUE, v -> v * v * 6.0 + v - 5000.0)));
        score += armor * armor * armor * 25.0 + armor * armor * 11.0;
        score += toughness * toughness * 30.0;
        score += enchantability > 0 ? (double)(enchantability * 5) + Math.log(enchantability) * 30.0 : 0.0;
        return (int)(score *= (multiplier *= 1.0 + knockbackResistance * 0.25));
    }

    private static double step(double val, Step ... steps) {
        double add = 0.0;
        double offset = 0.0;
        for (Step step : steps) {
            if (val <= step.limit) {
                add += step.func().get(val - offset);
                break;
            }
            double range = step.limit() - offset;
            add += step.func().get(range);
        }
        return add;
    }

    private record Step(double limit, Double2DoubleFunction func) {
    }
}

