/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.equipment;

import com.mojang.serialization.Codec;
import io.github.flemmli97.improvedmobs.common.config.equipment.WeightedItemstack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_5819;

public class WeightedItemstackList {
    public static final Codec<WeightedItemstackList> CODEC = WeightedItemstack.CODEC.listOf().xmap(WeightedItemstackList::new, l -> {
        ArrayList<WeightedItemstack> sorted = new ArrayList<WeightedItemstack>(l.values);
        sorted.sort(null);
        return sorted;
    });
    private final List<WeightedItemstack> values;
    private final List<WeightedItemstack> valid;
    private List<WeightedItemstack> filtered = new ArrayList<WeightedItemstack>();
    private int totalWeight;
    private double lastModifier = -1.0;

    public WeightedItemstackList(List<WeightedItemstack> values) {
        this.values = values;
        this.valid = this.values.stream().filter(WeightedItemstack::valid).toList();
    }

    public int getTotalWeight(double modifier) {
        if (this.lastModifier != modifier) {
            this.lastModifier = modifier;
            this.calculateTotalWeight(this.lastModifier);
        }
        return this.totalWeight;
    }

    public class_1799 getRandomStack(class_5819 random, double difficulty) {
        if (this.valid.isEmpty()) {
            return class_1799.field_8037;
        }
        int totalWeight = this.getTotalWeight(difficulty);
        if (totalWeight <= 0) {
            return class_1799.field_8037;
        }
        int index = random.method_43048(totalWeight);
        for (WeightedItemstack entry : this.filtered) {
            if ((index -= entry.getWeight(difficulty)) >= 0) continue;
            return entry.getItem();
        }
        return class_1799.field_8037;
    }

    private void calculateTotalWeight(double modifier) {
        this.filtered = this.valid.stream().filter(entry -> entry.getWeight(modifier) > 0).toList();
        this.totalWeight = this.filtered.stream().mapToInt(entry -> entry.getWeight(modifier)).sum();
    }

    public String toString() {
        return String.format("TotalWeight: %d ; [%s]", this.totalWeight, this.valid);
    }
}

