/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1835;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EntityItemConfig {
    private final List<String> config = new ArrayList<String>();
    private boolean initialized;
    private final Map<class_1299<?>, List<String>> itemBlacklist = new HashMap();

    @SafeVarargs
    public EntityItemConfig(Pair<String, String> ... values) {
        for (Pair<String, String> pair : values) {
            this.config.add((String)pair.getFirst() + ";" + (String)pair.getSecond());
        }
    }

    public boolean preventUse(class_1297 entity, class_1792 item) {
        this.initialize();
        List<String> items = this.itemBlacklist.get(entity.method_5864());
        String remap = this.vanillaRemapping(item);
        return items != null && (items.contains(class_7923.field_41178.method_10221((Object)item).toString()) || remap != null && items.contains(remap));
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap map = new HashMap();
        for (String value : this.config) {
            String[] sub = value.split(";");
            if (sub.length != 2) {
                ImprovedMobs.LOGGER.error("Invalid entity item config value for {}", (Object)value);
                continue;
            }
            class_7923.field_41177.method_17966(class_2960.method_60654((String)sub[0])).ifPresent(type -> map.computeIfAbsent(type, key -> new ArrayList()).add(sub[1]));
        }
        this.itemBlacklist.clear();
        this.itemBlacklist.putAll(map);
    }

    public void read(List<String> config) {
        this.config.clear();
        this.config.addAll(config);
        this.itemBlacklist.clear();
        this.initialized = false;
    }

    public List<String> writeToString() {
        return List.copyOf(this.config);
    }

    public static String use() {
        CharSequence[] str = new String[]{"<entity registry name;item>", "For different items but same entity use multiple lines", "Some special names are BOW, TRIDEN, CROSSBOW refering to every bow/trident/crossbow item (So you dont need to type e.g. every bow item)"};
        return String.join((CharSequence)"\n", str);
    }

    private String vanillaRemapping(class_1792 item) {
        if (item instanceof class_1753) {
            return "BOW";
        }
        if (item instanceof class_1835) {
            return "TRIDENT";
        }
        if (item instanceof class_1764) {
            return "CROSSBOW";
        }
        return null;
    }
}

