/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai;

import io.github.flemmli97.improvedmobs.ai.FlyNodeEvalRider;
import io.github.flemmli97.improvedmobs.entities.FlyingSummonEntity;
import io.github.flemmli97.improvedmobs.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.mixin.MobEntityMixin;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import org.jetbrains.annotations.Nullable;

public class FlyRidingGoal
extends Goal {
    protected final Mob living;
    private int iddle;
    private int pathCheckWait;
    private int flyDelay;
    private int targetDelay;
    private boolean start;
    private final PathNavigation flyer;

    public FlyRidingGoal(Mob living) {
        this.living = living;
        this.flyer = new FlyingPathNavigation(living, living.m_9236_()){

            protected PathFinder m_5532_(int maxVisitedNodes) {
                this.f_26508_ = new FlyNodeEvalRider();
                this.f_26508_.m_77351_(true);
                return new PathFinder(this.f_26508_, maxVisitedNodes);
            }

            @Nullable
            protected Path m_148222_(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return super.m_148222_(targets, regionOffset, offsetUpward, accuracy, followRange - 2.0f);
            }

            public boolean m_6342_(BlockPos blockPos) {
                return true;
            }
        };
    }

    public boolean m_8036_() {
        if (this.living.m_20202_() instanceof FlyingSummonEntity) {
            return true;
        }
        LivingEntity target = this.living.m_5448_();
        if (target == null || !target.m_6084_() || !this.living.m_21444_(target.m_20183_())) {
            this.targetDelay = 0;
        } else if (!this.living.m_20159_() && ++this.targetDelay > 40 && --this.pathCheckWait <= 0) {
            this.pathCheckWait = 25;
            if (this.checkFlying()) {
                this.targetDelay = 0;
                this.iddle = 0;
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.living.m_20202_() instanceof FlyingSummonEntity) {
            this.iddle = this.living.m_5448_() == null ? ++this.iddle : 0;
            return this.iddle < 100;
        }
        return false;
    }

    public void m_8041_() {
        Entity entity = this.living.m_20202_();
        if (entity instanceof RiddenSummonEntity) {
            RiddenSummonEntity mount = (RiddenSummonEntity)entity;
            mount.scheduledDismount();
        }
        this.living.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 1));
        this.iddle = 0;
        this.targetDelay = 0;
    }

    public void m_8056_() {
        this.start = true;
    }

    public void m_8037_() {
        FlyingSummonEntity summon;
        Entity entity;
        if (this.start) {
            if (!this.living.m_20159_()) {
                FlyingSummonEntity summon2 = new FlyingSummonEntity(this.living.m_9236_());
                BlockPos pos = this.living.m_20183_();
                summon2.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, this.living.m_146908_(), this.living.m_146909_());
                if (summon2.doesntCollideWithRidden((Entity)this.living)) {
                    this.living.m_9236_().m_7967_((Entity)summon2);
                    summon2.scheduledRide((Entity)this.living);
                    this.flyDelay = 0;
                }
            }
            this.start = false;
        }
        if (!((entity = this.living.m_20202_()) instanceof FlyingSummonEntity) || !(summon = (FlyingSummonEntity)entity).m_6084_()) {
            return;
        }
        if (++this.flyDelay >= 40 && this.isOnLand(entity)) {
            summon.scheduledDismount();
        }
    }

    private boolean checkFlying() {
        if (this.living.m_5842_()) {
            return false;
        }
        if ((double)Math.abs(this.living.f_20900_) > 0.005 || (double)Math.abs(this.living.f_20902_) > 0.005) {
            return false;
        }
        if (this.living.m_20068_() || !this.living.m_20096_()) {
            return false;
        }
        Path path = this.living.m_21573_().m_26570_();
        if (path == null || path.m_77392_() && !path.m_77403_()) {
            Path ground = this.living.m_21573_().m_6570_((Entity)this.living.m_5448_(), 1);
            if (ground != null && ground.m_77403_()) {
                return false;
            }
            Path flyer = this.flyer.m_6570_((Entity)this.living.m_5448_(), 1);
            double dist = ground == null || ground.m_77395_() == null ? (double)this.living.m_20183_().m_123333_((Vec3i)this.living.m_5448_().m_20183_()) : (double)ground.m_77395_().m_77306_(this.living.m_5448_().m_20183_());
            return flyer != null && (flyer.m_77403_() || (double)flyer.m_77407_() < dist);
        }
        return false;
    }

    private boolean isOnLand(Entity riding) {
        if (this.living.m_21573_().m_26571_() && riding.m_9236_().m_8055_(riding.m_20183_().m_7495_()).m_280296_()) {
            return true;
        }
        LivingEntity target = this.living.m_5448_();
        PathNavigation trueNav = ((MobEntityMixin)this.living).getTrueNavigator();
        if (target != null) {
            if (BehaviorUtils.m_22632_((Mob)this.living, (LivingEntity)target, (int)0)) {
                return riding.m_9236_().m_8055_(riding.m_20183_().m_7495_()).m_280296_();
            }
            if (--this.pathCheckWait > 0) {
                return false;
            }
            Path ground = trueNav.m_6570_((Entity)target, 1);
            this.pathCheckWait = 25;
            if (ground != null && ground.m_77403_()) {
                return riding.m_9236_().m_8055_(riding.m_20183_().m_7495_()).m_280296_();
            }
        }
        return false;
    }
}

