/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.difficulty;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface DifficultyGetter {
    public static List<Player> playersIn(EntityGetter getter, Vec3 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (Player player : getter.m_6907_()) {
            if (!player.m_20182_().m_82509_((Position)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public static float getDifficulty(Level level, Vec3 pos, Function<ServerPlayer, Float> getter) {
        return switch (Config.CommonConfig.difficultyType) {
            default -> throw new IncompatibleClassChangeError();
            case Config.DifficultyType.PLAYERMAX -> {
                float diff = 0.0f;
                for (Player player : DifficultyData.playersIn((EntityGetter)level, pos, 256.0)) {
                    float pD = getter.apply((ServerPlayer)player).floatValue();
                    if (!(pD > diff)) continue;
                    diff = pD;
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERSUM -> {
                float diff = 0.0f;
                for (Player player : DifficultyData.playersIn((EntityGetter)level, pos, 256.0)) {
                    diff += getter.apply((ServerPlayer)player).floatValue();
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERMEAN, Config.DifficultyType.GLOBAL, Config.DifficultyType.DISTANCE, Config.DifficultyType.DISTANCESPAWN -> {
                float diff = 0.0f;
                List<Player> list = DifficultyData.playersIn((EntityGetter)level, pos, 256.0);
                if (list.isEmpty()) {
                    yield 0.0f;
                }
                for (Player player : list) {
                    diff += getter.apply((ServerPlayer)player).floatValue();
                }
                yield diff / (float)list.size();
            }
        };
    }

    public float getDifficulty(ServerLevel var1, Vec3 var2);

    public Config.IntegrationType getType();

    default public boolean hasOwnDisplay() {
        return false;
    }
}

