/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.DifficultyConfig;
import io.github.flemmli97.improvedmobs.config.EquipmentList;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class IMCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"improvedmobs").executes(IMCommand::getDifficulty)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadJson").requires(src -> src.m_6761_(2))).executes(IMCommand::reloadJson))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"difficulty").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"player").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::setDifficultyPlayer)))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::addDifficultyPlayer)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::setDifficulty)))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::addDifficulty)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"pause").then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(src -> IMCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, GameProfileArgument.m_94590_((CommandContext)src, (String)"players"), true))))).executes(src -> IMCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, null, true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unpause").then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(src -> IMCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, GameProfileArgument.m_94590_((CommandContext)src, (String)"players"), false))))).executes(src -> IMCommand.pauseDifficulty((CommandContext<CommandSourceStack>)src, null, false)))).then(Commands.m_82127_((String)"simulate").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"steps", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(src -> IMCommand.simulateDifficulty((CommandContext<CommandSourceStack>)src, GameProfileArgument.m_94590_((CommandContext)src, (String)"players"), IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))).executes(src -> IMCommand.simulateDifficulty((CommandContext<CommandSourceStack>)src, null, IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))));
    }

    private static int reloadJson(CommandContext<CommandSourceStack> src) {
        ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)"Reloading equipment.json"), true);
        try {
            EquipmentList.initEquip();
        }
        catch (EquipmentList.InvalidItemNameException e) {
            ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)e.getMessage()), false);
        }
        return 1;
    }

    private static int setDifficulty(CommandContext<CommandSourceStack> src) {
        DifficultyData data = DifficultyData.get(((CommandSourceStack)src.getSource()).m_81377_());
        data.setDifficulty(FloatArgumentType.getFloat(src, (String)"val"), ((CommandSourceStack)src.getSource()).m_81377_());
        ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)("Difficulty set to " + data.getDifficulty())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int addDifficulty(CommandContext<CommandSourceStack> src) {
        DifficultyData data = DifficultyData.get(((CommandSourceStack)src.getSource()).m_81377_());
        data.addDifficulty(FloatArgumentType.getFloat(src, (String)"val"), ((CommandSourceStack)src.getSource()).m_81377_());
        ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)("Difficulty set to " + data.getDifficulty())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int setDifficultyPlayer(CommandContext<CommandSourceStack> src) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.m_94590_(src, (String)"players");
        MinecraftServer server = ((CommandSourceStack)src.getSource()).m_81377_();
        for (GameProfile prof : profs) {
            ServerPlayer player = server.m_6846_().m_11259_(prof.getId());
            CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player).ifPresent(data -> {
                data.setDifficultyLevel(FloatArgumentType.getFloat((CommandContext)src, (String)"val"));
                CrossPlatformStuff.INSTANCE.sendDifficultyDataTo(player, server);
                ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            });
        }
        return profs.size();
    }

    private static int addDifficultyPlayer(CommandContext<CommandSourceStack> src) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.m_94590_(src, (String)"players");
        MinecraftServer server = ((CommandSourceStack)src.getSource()).m_81377_();
        for (GameProfile prof : profs) {
            ServerPlayer player = server.m_6846_().m_11259_(prof.getId());
            CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player).ifPresent(data -> {
                data.setDifficultyLevel(data.getDifficultyLevel() + FloatArgumentType.getFloat((CommandContext)src, (String)"val"));
                CrossPlatformStuff.INSTANCE.sendDifficultyDataTo(player, server);
                ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            });
        }
        return profs.size();
    }

    private static int getDifficulty(CommandContext<CommandSourceStack> src) throws CommandSyntaxException {
        float diff;
        if (Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL) {
            diff = DifficultyData.get(((CommandSourceStack)src.getSource()).m_81377_()).getDifficulty();
        } else {
            ServerPlayer player = ((CommandSourceStack)src.getSource()).m_81375_();
            diff = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player).map(PlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
        }
        ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)("Difficulty: " + diff)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int pauseDifficulty(CommandContext<CommandSourceStack> src, Collection<GameProfile> profs, boolean pause) throws CommandSyntaxException {
        if (profs != null) {
            MinecraftServer server = ((CommandSourceStack)src.getSource()).m_81377_();
            for (GameProfile prof : profs) {
                ServerPlayer player = server.m_6846_().m_11259_(prof.getId());
                CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player).ifPresent(data -> data.setPaused(pause));
            }
            ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)("Difficulty " + (pause ? "paused" : "unpaused") + " for given players")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            return profs.size();
        }
        DifficultyData data2 = DifficultyData.get(((CommandSourceStack)src.getSource()).m_81377_());
        data2.setPaused(pause);
        ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)("Difficulty " + (pause ? "paused" : "unpaused"))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        return 1;
    }

    private static int simulateDifficulty(CommandContext<CommandSourceStack> src, Collection<GameProfile> profs, int steps) {
        if (profs != null) {
            MinecraftServer server = ((CommandSourceStack)src.getSource()).m_81377_();
            for (GameProfile prof : profs) {
                ServerPlayer player = server.m_6846_().m_11259_(prof.getId());
                CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player).ifPresent(data -> {
                    for (int i = steps; i > 0; --i) {
                        float current = data.getDifficultyLevel();
                        data.setDifficultyLevel(current + ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current).getRight()).start());
                    }
                });
                CrossPlatformStuff.INSTANCE.sendDifficultyDataTo(player, server);
            }
            ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Simulated %s difficulty steps for given players", steps)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            return profs.size();
        }
        DifficultyData data2 = DifficultyData.get(((CommandSourceStack)src.getSource()).m_81377_());
        float current = data2.getDifficulty();
        for (int i = steps; i > 0; --i) {
            current += ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current).getRight()).start();
        }
        data2.setDifficulty(current, ((CommandSourceStack)src.getSource()).m_81377_());
        ((CommandSourceStack)src.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Simulated %s difficulty steps globally. Now at %s", steps, Float.valueOf(data2.getDifficulty()))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        return 1;
    }
}

