/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.forge.events;

import com.mojang.brigadier.CommandDispatcher;
import io.github.flemmli97.improvedmobs.commands.IMCommand;
import io.github.flemmli97.improvedmobs.events.EventCalls;
import io.github.flemmli97.improvedmobs.forge.capability.ContainerCap;
import io.github.flemmli97.improvedmobs.forge.capability.PlayerDifficultyData;
import io.github.flemmli97.improvedmobs.forge.config.ConfigLoader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public static final ResourceLocation tileCap = new ResourceLocation("improvedmobs", "opened_flag");
    public static final ResourceLocation tilePlayer = new ResourceLocation("improvedmobs", "player_cap");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        event.addCapability(tileCap, (ICapabilityProvider)new ContainerCap());
    }

    @SubscribeEvent
    public void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayer) {
            event.addCapability(tilePlayer, (ICapabilityProvider)new PlayerDifficultyData());
        }
    }

    @SubscribeEvent
    public void worldLoad(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            ConfigLoader.serverInit(serverLevel);
        }
    }

    @SubscribeEvent
    public void commands(RegisterCommandsEvent event) {
        IMCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onEntityLoad(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            EventCalls.onEntityLoad(mob);
        }
    }

    @SubscribeEvent
    public void hurtEvent(LivingHurtEvent e) {
        e.setAmount(EventCalls.hurtEvent(e.getEntity(), e.getSource(), e.getAmount()));
    }

    @SubscribeEvent
    public void attackEvent(LivingAttackEvent e) {
        if (EventCalls.onAttackEvent(e.getEntity(), e.getSource())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void openTile(PlayerInteractEvent.RightClickBlock e) {
        EventCalls.openTile(e.getEntity(), e.getPos());
    }

    @SubscribeEvent
    public void equipPet(PlayerInteractEvent.EntityInteract e) {
        if (EventCalls.equipPet(e.getEntity(), e.getHand(), e.getTarget())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent e) {
        Projectile proj;
        Entity entity = e.getEntity();
        if (entity instanceof Projectile && EventCalls.projectileImpact(proj = (Projectile)entity, e.getRayTraceResult())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void explosion(ExplosionEvent.Detonate event) {
        EventCalls.explosion(event.getExplosion(), event.getExplosion().getExploder(), event.getAffectedEntities());
    }
}

