/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import io.github.flemmli97.improvedmobs.mixinhelper.IEntityData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class EntityFlags {
    public static final String TAG_ID = "IMFlags";
    public static final String SERVER_ENTITY_TAG_ID = "ServerSideEntityID";
    public boolean ladderClimber;
    public boolean modifyArmor;
    public boolean modifyHeldItems;
    public boolean modifyAttributes;
    public boolean enchantGear;
    public boolean isThrownEntity;
    public boolean isVariedSize;
    public FlagType canBreakBlocks = FlagType.UNDEF;
    public FlagType canFly = FlagType.UNDEF;
    private int shieldCooldown;
    public float magicRes;
    public float projMult = 1.0f;
    public float explosionMult = 1.0f;
    public ResourceLocation serverSideEntityID;

    public static EntityFlags get(Entity entity) {
        return ((IEntityData)entity).getFlags();
    }

    public void disableShield() {
        this.shieldCooldown = 120;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("CanBreakBlocks", this.canBreakBlocks.ordinal());
        tag.m_128405_("CanFly", this.canFly.ordinal());
        tag.m_128379_("ModifiedArmor", this.modifyArmor);
        tag.m_128379_("ModifiedHeld", this.modifyHeldItems);
        tag.m_128379_("ModifiedAttributes", this.modifyAttributes);
        tag.m_128379_("GearEnchanted", this.enchantGear);
        tag.m_128379_("IsThrown", this.isThrownEntity);
        tag.m_128379_("IsVariedSize", this.isVariedSize);
        tag.m_128350_("MagicRes", this.magicRes);
        tag.m_128350_("ProjBoost", this.projMult);
        tag.m_128350_("explosionMult", this.explosionMult);
        return tag;
    }

    public void load(CompoundTag nbt) {
        this.canBreakBlocks = FlagType.values()[nbt.m_128451_("CanBreakBlocks")];
        this.canFly = FlagType.values()[nbt.m_128451_("CanFly")];
        this.modifyArmor = nbt.m_128471_("ModifiedArmor");
        this.modifyHeldItems = nbt.m_128471_("ModifiedHeld");
        this.modifyAttributes = nbt.m_128471_("ModifiedAttributes");
        this.enchantGear = nbt.m_128471_("GearEnchanted");
        this.isThrownEntity = nbt.m_128471_("IsThrown");
        this.isVariedSize = nbt.m_128471_("IsVariedSize");
        this.magicRes = nbt.m_128457_("MagicRes");
        this.projMult = nbt.m_128441_("ProjBoost") ? nbt.m_128457_("ProjBoost") : 1.0f;
        float f = this.explosionMult = nbt.m_128441_("ExplosionBoost") ? nbt.m_128457_("ExplosionBoost") : 1.0f;
        if (nbt.m_128441_(SERVER_ENTITY_TAG_ID)) {
            this.serverSideEntityID = new ResourceLocation(nbt.m_128461_(SERVER_ENTITY_TAG_ID));
        }
    }

    public boolean isShieldDisabled() {
        return --this.shieldCooldown > 0;
    }

    public static enum FlagType {
        UNDEF,
        TRUE,
        FALSE;

    }
}

