/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.entities.ai;

import io.github.flemmli97.improvedmobs.common.entities.FlyingSummonEntity;
import io.github.flemmli97.improvedmobs.common.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.common.entities.ai.pathfinding.FlyNodeEvalRider;
import io.github.flemmli97.improvedmobs.mixin.MobEntityMixin;
import java.util.Set;
import net.minecraft.class_11;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_4215;
import org.jetbrains.annotations.Nullable;

public class FlyRidingGoal
extends class_1352 {
    protected final class_1308 living;
    private int idle;
    private int pathCheckWait;
    private int flyDelay;
    private int targetDelay;
    private boolean start;
    private final class_1408 flyer;

    public FlyRidingGoal(class_1308 living) {
        this.living = living;
        this.flyer = new class_1407(this, living, living.method_37908()){

            protected class_13 method_6336(int maxVisitedNodes) {
                this.field_6678 = new FlyNodeEvalRider();
                this.field_6678.method_15(true);
                return new class_13(this.field_6678, maxVisitedNodes);
            }

            @Nullable
            protected class_11 method_18416(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return super.method_18416(targets, regionOffset, offsetUpward, accuracy, followRange - 2.0f);
            }

            public boolean method_6333(class_2338 blockPos) {
                return true;
            }
        };
    }

    public boolean method_6264() {
        if (this.living.method_5854() instanceof FlyingSummonEntity) {
            return true;
        }
        if (this.isFlying()) {
            return false;
        }
        class_1309 target = this.living.method_5968();
        if (target == null || !target.method_5805() || !this.living.method_18407(target.method_24515())) {
            this.targetDelay = 0;
        } else if (!this.living.method_5765() && ++this.targetDelay > 100 && --this.pathCheckWait <= 0) {
            this.pathCheckWait = 30;
            if (this.checkFlying()) {
                this.targetDelay = 0;
                this.idle = 0;
                return true;
            }
        }
        return false;
    }

    private boolean isFlying() {
        return this.living.method_5942() instanceof class_1407;
    }

    public boolean method_6266() {
        if (this.living.method_5854() instanceof FlyingSummonEntity) {
            this.idle = this.living.method_5968() == null ? ++this.idle : 0;
            return this.idle < 100;
        }
        return false;
    }

    public void method_6270() {
        class_1297 class_12972 = this.living.method_5854();
        if (class_12972 instanceof RiddenSummonEntity) {
            RiddenSummonEntity mount = (RiddenSummonEntity)class_12972;
            mount.scheduledDismount();
        }
        this.living.method_6092(new class_1293(class_1294.field_5906, 200, 1));
        this.idle = 0;
        this.targetDelay = 0;
    }

    public void method_6269() {
        this.start = true;
    }

    public void method_6268() {
        FlyingSummonEntity summon;
        class_1297 entity;
        if (this.start) {
            if (!this.living.method_5765()) {
                FlyingSummonEntity summon2 = new FlyingSummonEntity(this.living.method_37908());
                class_2338 pos = this.living.method_24515();
                summon2.method_5808((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, this.living.method_36454(), this.living.method_36455());
                if (summon2.doesntCollideWithRidden((class_1297)this.living)) {
                    this.living.method_37908().method_8649((class_1297)summon2);
                    summon2.scheduledRide((class_1297)this.living);
                    this.flyDelay = 0;
                }
            }
            this.start = false;
        }
        if (!((entity = this.living.method_5854()) instanceof FlyingSummonEntity) || !(summon = (FlyingSummonEntity)entity).method_5805()) {
            return;
        }
        if (++this.flyDelay >= 40 && this.isOnLand(entity)) {
            summon.scheduledDismount();
        }
    }

    private boolean checkFlying() {
        if (this.living.method_5869()) {
            return false;
        }
        if (this.living.method_5740() || !this.living.method_24828()) {
            return false;
        }
        class_11 path = this.living.method_5942().method_6345();
        if (path == null || this.living.method_5942().method_31267() || path.method_46() || !path.method_21655()) {
            class_11 ground = this.living.method_5942().method_6349((class_1297)this.living.method_5968(), 1);
            if (ground != null && ground.method_21655()) {
                return false;
            }
            class_11 flyer = this.flyer.method_6349((class_1297)this.living.method_5968(), 1);
            double dist = ground == null || ground.method_45() == null ? (double)this.living.method_24515().method_19455((class_2382)this.living.method_5968().method_24515()) : (double)ground.method_45().method_21654(this.living.method_5968().method_24515());
            return flyer != null && (flyer.method_21655() || (double)flyer.method_21656() < dist);
        }
        return false;
    }

    private boolean isOnLand(class_1297 riding) {
        if (this.living.method_5942().method_6357() && riding.method_37908().method_8320(riding.method_24515().method_10074()).method_51367()) {
            return true;
        }
        class_1309 target = this.living.method_5968();
        class_1408 trueNav = ((MobEntityMixin)this.living).getTrueNavigator();
        if (target != null) {
            if (class_4215.method_25940((class_1308)this.living, (class_1309)target, (int)0)) {
                return riding.method_37908().method_8320(riding.method_24515().method_10074()).method_51367();
            }
            if (--this.pathCheckWait > 0) {
                return false;
            }
            class_11 ground = trueNav.method_6349((class_1297)target, 1);
            this.pathCheckWait = 25;
            if (ground != null && ground.method_21655()) {
                return riding.method_37908().method_8320(riding.method_24515().method_10074()).method_51367();
            }
        }
        return false;
    }
}

