/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.difficulty;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.difficulty.DifficultyData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface DifficultyGetter {
    public static List<Player> playersIn(EntityGetter getter, Vec3 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (Player player : getter.players()) {
            if (!player.position().closerThan((Position)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public static double getDifficulty(Level level, Vec3 pos, ToDoubleFunction<ServerPlayer> getter) {
        return switch (Config.CommonConfig.difficultyType) {
            default -> throw new MatchException(null, null);
            case Config.DifficultyType.PLAYERMAX -> {
                double diff = 0.0;
                for (Player player : DifficultyData.playersIn((EntityGetter)level, pos, 256.0)) {
                    double pD = getter.applyAsDouble((ServerPlayer)player);
                    if (!(pD > diff)) continue;
                    diff = pD;
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERSUM -> {
                double diff = 0.0;
                for (Player player : DifficultyData.playersIn((EntityGetter)level, pos, 256.0)) {
                    diff += getter.applyAsDouble((ServerPlayer)player);
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERMEAN, Config.DifficultyType.GLOBAL, Config.DifficultyType.DISTANCE, Config.DifficultyType.DISTANCESPAWN -> {
                double diff = 0.0;
                List<Player> list = DifficultyData.playersIn((EntityGetter)level, pos, 256.0);
                if (list.isEmpty()) {
                    yield 0.0;
                }
                for (Player player : list) {
                    diff += getter.applyAsDouble((ServerPlayer)player);
                }
                yield diff / (double)list.size();
            }
        };
    }

    public double getDifficulty(ServerLevel var1, Vec3 var2);

    public Config.IntegrationType getType();

    default public boolean hasOwnDisplay() {
        return false;
    }
}

