/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.difficulty.impl;

import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyGetter;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.common.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.Vec3;

public class DefaultDifficulty
implements DifficultyGetter {
    @Override
    public double getDifficulty(ServerLevel level, Vec3 pos) {
        return switch (Config.CommonConfig.difficultyType) {
            default -> throw new MatchException(null, null);
            case Config.DifficultyType.GLOBAL -> DifficultyData.get(level.getServer()).getDifficulty();
            case Config.DifficultyType.PLAYERMAX -> {
                double diff = 0.0;
                for (Player player : DifficultyGetter.playersIn((EntityGetter)level, pos, 256.0)) {
                    double pD = ((PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player)).getDifficultyLevel();
                    if (!(pD > diff)) continue;
                    diff = pD;
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERSUM -> {
                double diff = 0.0;
                for (Player player : DifficultyData.playersIn((EntityGetter)level, pos, 256.0)) {
                    diff += ((PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player)).getDifficultyLevel();
                }
                yield diff;
            }
            case Config.DifficultyType.PLAYERMEAN -> {
                double diff = 0.0;
                List<Player> list = DifficultyGetter.playersIn((EntityGetter)level, pos, 256.0);
                if (list.isEmpty()) {
                    yield 0.0;
                }
                for (Player player : list) {
                    diff += ((PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player)).getDifficultyLevel();
                }
                yield diff / (double)list.size();
            }
            case Config.DifficultyType.DISTANCE, Config.DifficultyType.DISTANCESPAWN -> DifficultyData.getDifficultyFromDist(level, pos);
        };
    }

    @Override
    public Config.IntegrationType getType() {
        return Config.IntegrationType.ON;
    }
}

