/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.item.impl;

import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import io.github.flemmli97.improvedmobs.common.entities.ai.util.AIUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class EnderpearlHandler
implements ItemUseHandler {
    @Override
    public void use(LivingEntity entity, LivingEntity target, InteractionHand hand) {
        double dis = entity.position().distanceToSqr(target.position());
        if (dis > 49.0) {
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (entity.level().random.nextFloat() * 0.4f + 0.8f));
            if (!entity.level().isClientSide) {
                Vec3 v1 = entity.position().subtract(target.position()).normalize().scale(16.0);
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                if (entity.position().subtract(target.position()).length() > 16.0) {
                    x = v1.x;
                    y = v1.y;
                    z = v1.z;
                }
                ThrownEnderpearl pearl = new ThrownEnderpearl(entity.level(), entity);
                AIUtils.setHeadingToPosition((ThrowableProjectile)pearl, target.getX() - x, target.getY() - y, target.getZ() - z, 1.5f, 3.0f);
                entity.level().addFreshEntity((Entity)pearl);
            }
        }
    }

    @Override
    public ItemUseHandler.PreferredHand preferredHand() {
        return ItemUseHandler.PreferredHand.ANY;
    }

    @Override
    public int cooldown(LivingEntity entity) {
        return 30 + entity.getRandom().nextInt(20);
    }

    @Override
    public boolean matches(Item item) {
        return item == Items.ENDER_PEARL;
    }
}

