/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.item.impl.move;

import io.github.flemmli97.improvedmobs.api.item.MoveHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class KeepDistanceMover
implements MoveHandler {
    private final Mob mob;
    private final double maxAttackDistance;
    private int seeTime;

    public KeepDistanceMover(Mob mob) {
        this(mob, 12.0);
    }

    public KeepDistanceMover(Mob mob, double dist) {
        this.mob = mob;
        this.maxAttackDistance = MoveHandler.defaultRangeOf(mob, dist);
    }

    @Override
    public void move(LivingEntity target, boolean canSee) {
        Mob mob;
        double dist = this.mob.distanceToSqr(target.getX(), target.getY(), target.getZ());
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (dist > this.maxAttackDistance || this.seeTime < 5) {
            this.mob.getNavigation().moveTo((Entity)target, 1.0);
        } else if (dist <= this.maxAttackDistance * 0.3 && (mob = this.mob) instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            Vec3 posAway = DefaultRandomPos.getPosAway((PathfinderMob)pathfinderMob, (int)7, (int)5, (Vec3)target.position());
            if (posAway != null) {
                this.mob.getNavigation().moveTo(posAway.x(), posAway.y(), posAway.z(), 1.0);
            }
        } else {
            this.mob.getNavigation().stop();
        }
        this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
    }
}

