/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.item.impl.move;

import io.github.flemmli97.improvedmobs.api.item.MoveHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class StrafingMover
implements MoveHandler {
    private final Mob mob;
    private final double maxAttackDistance;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public StrafingMover(Mob mob) {
        this(mob, 12.0);
    }

    public StrafingMover(Mob mob, double dist) {
        this.mob = mob;
        this.maxAttackDistance = MoveHandler.defaultRangeOf(mob, dist);
    }

    @Override
    public void move(LivingEntity target, boolean canSee) {
        boolean flag1;
        double dist = this.mob.distanceToSqr(target.getX(), target.getY(), target.getZ());
        boolean bl = flag1 = this.seeTime > 0;
        if (canSee != flag1) {
            this.seeTime = 0;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        if (dist <= this.maxAttackDistance && this.seeTime >= 20) {
            this.mob.getNavigation().stop();
            ++this.strafingTime;
        } else {
            this.mob.getNavigation().moveTo((Entity)target, 1.0);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (dist > this.maxAttackDistance * 0.75) {
                this.strafingBackwards = false;
            } else if (dist < this.maxAttackDistance * 0.25) {
                this.strafingBackwards = true;
            }
            this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.mob.lookAt((Entity)target, 30.0f, 30.0f);
        } else {
            this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
    }
}

