/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.client;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.common.config.Config;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ClientEvents {
    private static double clientDifficulty;
    private static final ResourceLocation BAR;

    public static void displayDifficulty(GuiGraphics graphics) {
        if (!Config.ClientConfig.showDifficultyServerSync || !Config.ClientConfig.showDifficulty || Minecraft.getInstance().gui.getDebugOverlay().showDebugScreen()) {
            return;
        }
        graphics.pose().pushPose();
        Font font = Minecraft.getInstance().font;
        MutableComponent txt = Component.translatable((String)"improvedmobs.overlay.difficulty", (Object[])new Object[]{String.format(Locale.US, "%.1f", clientDifficulty)}).withStyle(Config.ClientConfig.color);
        float scale = Config.ClientConfig.scale;
        graphics.pose().scale(scale, scale, scale);
        int width = font.width((FormattedText)txt);
        int x = Config.ClientConfig.guiX;
        int y = Config.ClientConfig.guiY;
        switch (Config.ClientConfig.location) {
            case TOPRIGHT: {
                x = Minecraft.getInstance().getWindow().getGuiScaledWidth() - 7 - width - Config.ClientConfig.guiX;
                break;
            }
            case BOTTOMRIGHT: {
                x = Minecraft.getInstance().getWindow().getGuiScaledWidth() - 7 - width - Config.ClientConfig.guiX;
                y = Minecraft.getInstance().getWindow().getGuiScaledHeight() - 17 - Config.ClientConfig.guiY;
                break;
            }
            case BOTTOMLEFT: {
                y = Minecraft.getInstance().getWindow().getGuiScaledHeight() - 17 - Config.ClientConfig.guiY;
            }
        }
        graphics.blit(BAR, x, y, 0.0f, 0.0f, 4 + width, 17, 256, 256);
        graphics.blit(BAR, x + 4 + width, y, 183.0f, 0.0f, 3, 17, 256, 256);
        graphics.drawString(font, (Component)Component.translatable((String)"improvedmobs.overlay.difficulty", (Object[])new Object[]{String.format(Locale.US, "%.1f", clientDifficulty)}).withStyle(Config.ClientConfig.color), x + 4, y + 5, 0, false);
        graphics.pose().popPose();
    }

    public static void updateClientDifficulty(double difficulty) {
        clientDifficulty = difficulty;
    }

    static {
        BAR = ImprovedMobs.modRes("textures/gui/difficulty_bar.png");
    }
}

