/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.improvedmobs.api.DifficultyFeatures;
import io.github.flemmli97.improvedmobs.common.config.values.BreakableBlocks;
import io.github.flemmli97.improvedmobs.common.config.values.DifficultyExpressionConfig;
import io.github.flemmli97.improvedmobs.common.config.values.EntityFeatureConfig;
import io.github.flemmli97.improvedmobs.common.config.values.EntityItemConfig;
import io.github.flemmli97.improvedmobs.common.config.values.ExpressionConfig;
import io.github.flemmli97.improvedmobs.common.config.values.Pos2iConfig;
import io.github.flemmli97.improvedmobs.common.config.values.StepExpressionConfig;
import io.github.flemmli97.improvedmobs.common.config.values.TargetMapConfig;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class Config {
    public static VariableMap create(LivingEntity entity, double difficulty) {
        return Config.apply(new VariableMap(), entity, difficulty);
    }

    public static VariableMap apply(VariableMap variables, LivingEntity entity, double difficulty) {
        return Config.apply(variables, entity.getRandom(), entity.level().getSharedSpawnPos(), entity.position(), difficulty);
    }

    public static VariableMap apply(VariableMap variables, RandomSource random, BlockPos spawn, Vec3 pos, double difficulty) {
        double distSpawn = Math.sqrt(pos.distanceToSqr((double)spawn.getX() + 0.5, pos.y(), (double)spawn.getZ() + 0.5));
        double distOrigin = Math.sqrt(pos.distanceToSqr(0.5, pos.y(), 0.5));
        double distCenter = Math.sqrt(pos.distanceToSqr((double)CommonConfig.centerPos.getPos().x() + 0.5, pos.y(), (double)CommonConfig.centerPos.getPos().z() + 0.5));
        return variables.withRandom(random).setVariable("difficulty", difficulty).setVariable("distance_spawn", distSpawn).setVariable("distance_origin", distOrigin).setVariable("distance_center", distCenter);
    }

    public static class CommonConfig {
        public static boolean enableDifficultyScaling = true;
        public static int difficultyDelay;
        public static boolean ignoreSpawner;
        public static DifficultyExpressionConfig difficultyIncrease;
        public static boolean ignorePlayers;
        public static boolean considerTimeskip;
        public static boolean friendlyFire;
        public static DifficultyType difficultyType;
        public static Pos2iConfig centerPos;
        public static List<String> petArmorBlackList;
        public static boolean petWhiteList;
        public static Set<DifficultyFeatures> featureBlacklist;
        public static EntityFeatureConfig entityBlacklist;
        public static Set<DifficultyFeatures> featureWhitelist;
        public static IntegrationType vanillaClamped;
        public static float vanillaClampedMax;
        public static IntegrationType usePowerScaleMod;
        public static IntegrationType usePlayerEXMod;
        public static float playerEXScale;
        public static IntegrationType useLevelZMod;
        public static float levelZScale;
        public static IntegrationType useRunecraftoryMod;
        public static float runecraftoryScale;
        public static BreakableBlocks breakableBlocks;
        public static boolean breakingAsBlacklist;
        public static boolean useBlockBreakSound;
        public static ExpressionConfig breakerChance;
        public static float difficultyBreak;
        public static int breakerInitCooldown;
        public static int breakerCooldown;
        public static boolean ignoreHarvestLevel;
        public static int restoreDelay;
        public static boolean idleBreak;
        public static float breakerSightIgnore;
        public static ExpressionConfig breakSpeed;
        public static ExpressionConfig stealerChance;
        public static float difficultySteal;
        public static List<String> blackListedContainerBlocks;
        public static boolean breakBlockEntities;
        public static List<WeightedItem> breakingItem;
        public static ExpressionConfig neutralAggressiv;
        public static ExpressionConfig guardianAIChance;
        public static ExpressionConfig flyAIChance;
        public static boolean tntBlockDestruction;
        public static ExpressionConfig ignoreSightChance;
        public static TargetMapConfig autoTargets;
        public static List<String> equipmentModBlacklist;
        public static boolean equipmentModWhitelist;
        public static List<String> itemuseBlacklist;
        public static boolean itemuseWhitelist;
        public static EntityItemConfig entityItemConfig;
        public static ExpressionConfig equipmentChance;
        public static ExpressionConfig additionalEquipmentChance;
        public static ExpressionConfig randomTrimChance;
        public static ExpressionConfig mainHandChance;
        public static ExpressionConfig offHandChance;
        public static ExpressionConfig dropChance;
        public static ExpressionConfig enchantChance;
        public static StepExpressionConfig enchantCalc;
        public static List<String> enchantBlacklist;
        public static boolean enchantWhitelist;

        public static ItemStack getRandomBreakingItem(RandomSource rand) {
            int total = WeightedRandom.getTotalWeight(breakingItem);
            if (breakingItem.isEmpty() || total <= 0) {
                return ItemStack.EMPTY;
            }
            return WeightedRandom.getRandomItem((RandomSource)rand, breakingItem, (int)total).map(WeightedItem::getStack).orElse(ItemStack.EMPTY);
        }

        static {
            difficultyIncrease = new DifficultyExpressionConfig(new DifficultyExpressionConfig.UnresolvedValue(0.0, "difficulty + 0.1"), new DifficultyExpressionConfig.UnresolvedValue(250.0, "difficulty"));
            considerTimeskip = true;
            difficultyType = DifficultyType.PLAYERMEAN;
            centerPos = new Pos2iConfig();
            petArmorBlackList = new ArrayList<String>();
            featureBlacklist = EnumSet.noneOf(DifficultyFeatures.class);
            entityBlacklist = new EntityFeatureConfig();
            featureWhitelist = EnumSet.noneOf(DifficultyFeatures.class);
            vanillaClamped = IntegrationType.OFF;
            vanillaClampedMax = 250.0f;
            usePowerScaleMod = IntegrationType.ON;
            usePlayerEXMod = IntegrationType.ON;
            playerEXScale = 1.0f;
            useLevelZMod = IntegrationType.ON;
            levelZScale = 1.0f;
            useRunecraftoryMod = IntegrationType.ON;
            runecraftoryScale = 1.0f;
            breakableBlocks = new BreakableBlocks("#c:glass_blocks", "#c:glass_panes", "#minecraft:fence_gates", "#c:fence_gates", "#minecraft:wooden_doors");
            useBlockBreakSound = true;
            breakerChance = new ExpressionConfig("0.3");
            breakerInitCooldown = 120;
            breakerCooldown = 20;
            breakerSightIgnore = 1.0f;
            breakSpeed = new ExpressionConfig("1");
            stealerChance = new ExpressionConfig("1");
            blackListedContainerBlocks = new ArrayList<String>();
            breakBlockEntities = true;
            breakingItem = new ArrayList<WeightedItem>();
            neutralAggressiv = new ExpressionConfig("0.05");
            guardianAIChance = new ExpressionConfig("0.5");
            flyAIChance = new ExpressionConfig("0.5");
            ignoreSightChance = new ExpressionConfig("0.5");
            autoTargets = new TargetMapConfig();
            equipmentModBlacklist = new ArrayList<String>();
            itemuseBlacklist = new ArrayList<String>(List.of("bigbrain:buckler"));
            entityItemConfig = new EntityItemConfig(Pair.of((Object)"minecraft:skeleton", (Object)"BOW"), Pair.of((Object)"minecraft:wither_skeleton", (Object)"BOW"), Pair.of((Object)"minecraft:stray", (Object)"BOW"), Pair.of((Object)"minecraft:illusioner", (Object)"BOW"), Pair.of((Object)"minecraft:drowned", (Object)"TRIDENT"), Pair.of((Object)"minecraft:piglin", (Object)"CROSSBOW"), Pair.of((Object)"minecraft:pillager", (Object)"CROSSBOW"), Pair.of((Object)"minecraft:snow_golem", (Object)"minecraft:snowball"));
            equipmentChance = new ExpressionConfig("0.1 + min(difficulty * 0.8 / 250, 0.8)");
            additionalEquipmentChance = new ExpressionConfig("0.3 + min(difficulty * 0.6 / 250, 0.6)");
            randomTrimChance = new ExpressionConfig("0.05 + min(difficulty * 0.2 / 250, 0.2)");
            mainHandChance = new ExpressionConfig("0.1 + min(difficulty * 0.3 / 250, 0.3)");
            offHandChance = new ExpressionConfig("0.1 + min(difficulty * 0.3 / 250, 0.3)");
            dropChance = new ExpressionConfig("0");
            enchantChance = new ExpressionConfig("0.2 + min(difficulty * 0.6 / 250, 0.6)");
            enchantCalc = new StepExpressionConfig(StepExpressionConfig.ENCHANT_DEFAULT, new StepExpressionConfig.Value(0.0, "random_integer(1, 10)"), new StepExpressionConfig.Value(25.0, "random_integer(5, 15)"), new StepExpressionConfig.Value(50.0, "random_integer(10, 17)"), new StepExpressionConfig.Value(100.0, "random_integer(15, 25)"), new StepExpressionConfig.Value(200.0, "random_integer(20, 30)"), new StepExpressionConfig.Value(250.0, "random_integer(30, 35)"));
            enchantBlacklist = new ArrayList<String>();
        }
    }

    public static enum IntegrationType {
        OFF,
        ON,
        ADD;


        public boolean enabled() {
            return this != OFF;
        }
    }

    public static enum DifficultyBarLocation {
        TOPRIGHT,
        TOPLEFT,
        BOTTOMRIGHT,
        BOTTOMLEFT;

    }

    public static enum DifficultyType {
        GLOBAL(true),
        PLAYERMAX(true),
        PLAYERMEAN(true),
        PLAYERSUM(true),
        DISTANCE(false),
        DISTANCESPAWN(false);

        public final boolean increaseDifficulty;

        private DifficultyType(boolean increaseDifficulty) {
            this.increaseDifficulty = increaseDifficulty;
        }
    }

    private static class LazyItem {
        private final String config;
        private Item item;

        public LazyItem(String item) {
            this.config = item;
        }

        public ItemStack getStack() {
            if (this.item == null) {
                this.item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.config));
            }
            return new ItemStack((ItemLike)this.item);
        }
    }

    public static class WeightedItem
    implements WeightedEntry {
        private final LazyItem item;
        private final int weight;

        public WeightedItem(String item, int weight) {
            this.weight = weight;
            this.item = new LazyItem(item);
        }

        public ItemStack getStack() {
            return this.item.getStack();
        }

        public Weight getWeight() {
            return Weight.of((int)this.weight);
        }
    }

    public static class ClientConfig {
        public static int guiX = 5;
        public static int guiY = 5;
        public static ChatFormatting color = ChatFormatting.DARK_PURPLE;
        public static float scale = 1.0f;
        public static boolean showDifficulty = true;
        public static DifficultyBarLocation location = DifficultyBarLocation.TOPLEFT;
        public static boolean showDifficultyServerSync;
    }
}

