/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.equipment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.datapack.ItemUseLookupManager;
import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import io.github.flemmli97.improvedmobs.common.config.equipment.OptionalItemStack;
import io.github.flemmli97.improvedmobs.common.config.equipment.WeightedItemstack;
import io.github.flemmli97.improvedmobs.common.config.equipment.WeightedItemstackList;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class EquipmentList {
    private static final int CONFIG_VERSION = 2;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Codec<Map<EquipmentSlot, WeightedItemstackList>> CODEC = Codec.unboundedMap((Codec)CodecUtils.stringEnumCodec(EquipmentSlot.class, null), WeightedItemstackList.CODEC).xmap(EnumMap::new, m -> m);
    private static Map<EquipmentSlot, WeightedItemstackList> EQUIPMENTS = new EnumMap<EquipmentSlot, WeightedItemstackList>(EquipmentSlot.class);

    public static ItemStack getEquipment(Mob mob, EquipmentSlot slot, double difficulty) {
        WeightedItemstackList eq = EQUIPMENTS.get(slot);
        if (eq == null) {
            return ItemStack.EMPTY;
        }
        return eq.getRandomStack(mob.getRandom(), difficulty);
    }

    public static void initEquip(HolderLookup.Provider provider, ItemUseLookupManager manager) {
        try {
            Path path = CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json");
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            if (!Files.exists(path, new LinkOption[0])) {
                EquipmentList.initDefaultVals(manager);
                Files.createFile(path, new FileAttribute[0]);
            } else {
                BufferedReader reader = Files.newBufferedReader(path);
                JsonObject config = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (config == null) {
                    config = new JsonObject();
                }
                reader.close();
                int version = GsonHelper.getAsInt((JsonObject)config, (String)"version", (int)1);
                if (version < 2) {
                    ImprovedMobs.LOGGER.debug("You are having a legacy config. A Backup will be created");
                    EquipmentList.createBackup(manager);
                } else {
                    EQUIPMENTS = (Map)CODEC.parse((DynamicOps)ops, (Object)config).getPartialOrThrow();
                }
            }
            JsonObject updated = new JsonObject();
            updated.addProperty("version", (Number)2);
            updated.add("__comment", (JsonElement)EquipmentList.commentObj());
            JsonElement data = (JsonElement)CODEC.encodeStart((DynamicOps)ops, EQUIPMENTS).getOrThrow();
            if (data.isJsonObject()) {
                data.getAsJsonObject().entrySet().forEach(e -> updated.add((String)e.getKey(), (JsonElement)e.getValue()));
            }
            JsonWriter wr = GSON.newJsonWriter((Writer)Files.newBufferedWriter(path, StandardOpenOption.TRUNCATE_EXISTING));
            GSON.toJson((Object)updated, JsonObject.class, wr);
            wr.close();
        }
        catch (IOException | IllegalStateException e2) {
            ImprovedMobs.LOGGER.error("Error initializing equipment file", (Throwable)e2);
        }
    }

    private static JsonArray commentObj() {
        JsonArray comment = new JsonArray();
        comment.add("Mobs will be able to equip items declared here");
        comment.add("Value is the item. It also accepts item components. The default config has an example with a harming potion");
        comment.add("Weight is the weight of an item. Higher weight means that the item is more likely to get choosen");
        comment.add("Quality is a modifier applied to the weight. The final weight used is weight + quality * current difficulty");
        return comment;
    }

    private static void createBackup(ItemUseLookupManager manager) {
        try {
            Files.move(CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json"), CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json.bak"), new CopyOption[0]);
            EquipmentList.initDefaultVals(manager);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initDefaultVals(ItemUseLookupManager manager) {
        EQUIPMENTS = new EnumMap<EquipmentSlot, WeightedItemstackList>(EquipmentSlot.class);
        HashMap inverseWeight = new HashMap();
        BuiltInRegistries.ITEM.holders().forEach(holder -> {
            Equipable equipable;
            ItemUseHandler ai;
            EquipmentSlot slot = null;
            Item item = (Item)holder.value();
            if (item instanceof BowItem) {
                slot = EquipmentSlot.MAINHAND;
            }
            if ((ai = (ItemUseHandler)manager.get(item).stream().findFirst().orElse(null)) != null) {
                slot = ai.defaultedSlot();
            }
            if (item instanceof Equipable && (equipable = (Equipable)item).getEquipmentSlot().getType() != EquipmentSlot.Type.ANIMAL_ARMOR) {
                slot = equipable.getEquipmentSlot();
            }
            if ((item instanceof SwordItem || item instanceof DiggerItem) && !EquipmentList.defaultBlackLists(item)) {
                slot = EquipmentSlot.MAINHAND;
            }
            if (slot != null) {
                OptionalItemStack stack = item instanceof ThrowablePotionItem ? new OptionalItemStack((Holder.Reference<Item>)holder, m -> m.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.HARMING))) : new OptionalItemStack((Holder.Reference<Item>)holder);
                inverseWeight.computeIfAbsent(slot, k -> new ArrayList()).add(Pair.of((Object)EquipmentList.score(item), (Object)stack));
            }
        });
        for (Map.Entry entry : inverseWeight.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            List<Pair> sorted = ((List)entry.getValue()).stream().sorted(Comparator.comparingInt(Pair::getFirst)).toList();
            int total = ((List)entry.getValue()).stream().mapToInt(Pair::getFirst).sum();
            float max = 1.0f / (float)((Integer)sorted.getFirst().getFirst()).intValue() * (float)total;
            float median = 1.0f / (float)((Integer)sorted.get((int)((double)sorted.size() * 0.5)).getFirst()).intValue() * (float)total;
            WeightedItemstackList list = new WeightedItemstackList(((List)entry.getValue()).stream().map(p -> {
                float[] normalized = EquipmentList.normalizeAndInvertWeight((Integer)p.getFirst(), max, median, total);
                return new WeightedItemstack((OptionalItemStack)p.getSecond(), (int)normalized[0], normalized[1]);
            }).toList());
            EQUIPMENTS.put((EquipmentSlot)entry.getKey(), list);
        }
    }

    private static float[] normalizeAndInvertWeight(int score, float max, float median, int total) {
        float weight = 1.0f / (float)score * (float)total;
        float quality = (max - weight) / (median * 1.5f) + 0.5f;
        return new float[]{Math.round(weight * 100.0f), quality * quality};
    }

    private static boolean defaultBlackLists(Item item) {
        if (item instanceof DiggerItem && !(item instanceof AxeItem)) {
            return true;
        }
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace().equals("mobbattle");
    }

    private static int score(Item item) {
        double score = 0.0;
        int durability = (Integer)item.components().getOrDefault(DataComponents.MAX_DAMAGE, (Object)0);
        ItemStack stack = new ItemStack((ItemLike)item);
        double damage = ItemUtils.attribute((ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (double)1.0, (EquipmentSlotGroup[])EquipmentSlotGroup.values());
        double armor = ItemUtils.attribute((ItemStack)stack, (Holder)Attributes.ARMOR, (double)1.0, (EquipmentSlotGroup[])EquipmentSlotGroup.values());
        double toughness = ItemUtils.attribute((ItemStack)stack, (Holder)Attributes.ARMOR_TOUGHNESS, (double)1.0, (EquipmentSlotGroup[])EquipmentSlotGroup.values());
        double knockbackResistance = ItemUtils.attribute((ItemStack)stack, (Holder)Attributes.KNOCKBACK_RESISTANCE, (double)1.0, (EquipmentSlotGroup[])EquipmentSlotGroup.values());
        int enchantability = item.getEnchantmentValue();
        double multiplier = 1.0;
        if (item.components().has(DataComponents.UNBREAKABLE)) {
            multiplier *= 2.5;
        }
        if ((armor > 1.0 || damage > 1.0) && durability <= 0) {
            durability = 1000;
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            try {
                multiplier *= !((Ingredient)((ArmorMaterial)armorItem.getMaterial().value()).repairIngredient().get()).isEmpty() ? 1.1 : 1.0;
            }
            catch (Exception e) {
                ImprovedMobs.LOGGER.error("Cannot compute repair ingredient {}", (Object)BuiltInRegistries.ITEM.getKey((Object)item), (Object)e);
            }
            multiplier *= armorItem.getMaterial() == ArmorMaterials.LEATHER || armorItem.getMaterial() == ArmorMaterials.GOLD || armorItem.getMaterial() == ArmorMaterials.CHAIN || armorItem.getMaterial() == ArmorMaterials.IRON || armorItem.getMaterial() == ArmorMaterials.DIAMOND || armorItem.getMaterial() == ArmorMaterials.NETHERITE || armorItem.getMaterial() == ArmorMaterials.TURTLE ? 1.2 : 1.0;
        } else if (item == Items.FLINT_AND_STEEL) {
            score = 800.0;
        } else if (item instanceof ShieldItem) {
            score = 1200.0;
        } else if (item instanceof BowItem) {
            BowItem bow = (BowItem)item;
            score = 1000 + bow.getDefaultProjectileRange() * 15;
        } else if (item instanceof TridentItem) {
            multiplier *= 1.1;
        } else if (item instanceof CrossbowItem) {
            CrossbowItem crossbow = (CrossbowItem)item;
            score = 1000 + crossbow.getDefaultProjectileRange() * 15;
        } else if (item instanceof FishingRodItem) {
            score = 900.0;
        } else if (item == Items.LAVA_BUCKET) {
            score = 2200.0;
        } else if (item == Items.ENDER_PEARL) {
            score = 1800.0;
        } else if (item == Items.SNOWBALL) {
            score = 500.0;
        } else if (item instanceof ThrowablePotionItem) {
            score = 1500.0;
        } else if (item == Items.ENCHANTED_BOOK) {
            score = 1900.0;
        } else if (item == Blocks.TNT.asItem()) {
            score = 2200.0;
        }
        score += Math.sqrt(durability) * 15.0;
        score += Math.max(0.0, EquipmentList.step(damage, new Step(10.0, v -> (v * v * v * 3.0 - v * 5.0) * 2.5), new Step(40.0, v -> v * v * 8.0 + v * 5.0 + Math.sqrt(v * 50.0)), new Step(Double.MAX_VALUE, v -> v * v * 6.0 + v - 5000.0)));
        score += armor * armor * armor * 25.0 + armor * armor * 11.0;
        score += toughness * toughness * 30.0;
        score += enchantability > 0 ? (double)(enchantability * 5) + Math.log(enchantability) * 30.0 : 0.0;
        return (int)(score *= (multiplier *= 1.0 + knockbackResistance * 0.25));
    }

    private static double step(double val, Step ... steps) {
        double add = 0.0;
        double offset = 0.0;
        for (Step step : steps) {
            if (val <= step.limit) {
                add += step.func().get(val - offset);
                break;
            }
            double range = step.limit() - offset;
            add += step.func().get(range);
        }
        return add;
    }

    private record Step(double limit, Double2DoubleFunction func) {
    }
}

