/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import io.github.flemmli97.improvedmobs.api.datapack.EntityOverridesManager;
import io.github.flemmli97.improvedmobs.common.config.Config;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class BreakableBlocks {
    private final List<String> config = new ArrayList<String>();
    private boolean initialized;
    private final Set<Block> blocks = new HashSet<Block>();

    public BreakableBlocks(String ... defaultVal) {
        this.config.addAll(List.of(defaultVal));
    }

    public boolean canBreak(BlockState state, BlockPos pos, BlockGetter level, @Nullable Entity entity, CollisionContext ctx) {
        Mob mob;
        this.initialize();
        if (!Config.CommonConfig.idleBreak && entity instanceof Mob && (mob = (Mob)entity).getTarget() == null) {
            return false;
        }
        if (state.getCollisionShape(level, pos, ctx).isEmpty()) {
            return false;
        }
        if (!Config.CommonConfig.breakBlockEntities && state.hasBlockEntity()) {
            return false;
        }
        if (entity instanceof Mob) {
            mob = (Mob)entity;
            EntityOverridesManager.OverrideState override = EntityOverridesManager.getInstance().canBreak((LivingEntity)mob, state);
            if (override == EntityOverridesManager.OverrideState.ALLOW) {
                return true;
            }
            if (override == EntityOverridesManager.OverrideState.DENY) {
                return false;
            }
        }
        if (Config.CommonConfig.breakingAsBlacklist) {
            return !this.blocks.contains(state.getBlock());
        }
        return this.blocks.contains(state.getBlock());
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        BuiltInRegistries.BLOCK.holders().forEach(block -> {
            boolean contains;
            ResourceLocation id = block.key().location();
            boolean bl = contains = this.config.contains(id.toString()) || this.config.contains(id.getNamespace()) || block.tags().anyMatch(tag -> this.config.contains("#" + String.valueOf(tag.location())));
            if (contains) {
                boolean blocked;
                boolean bl2 = blocked = this.config.contains("!" + String.valueOf(id)) || this.config.contains("!" + id.getNamespace()) || block.tags().anyMatch(tag -> this.config.contains("!#" + String.valueOf(tag.location())));
                if (!blocked) {
                    this.blocks.add((Block)block.value());
                }
            }
        });
    }

    public void tagReloaded() {
        this.blocks.clear();
        this.initialized = false;
        this.initialize();
    }

    public void read(List<String> arr) {
        this.config.clear();
        this.config.addAll(arr);
        this.blocks.clear();
        this.initialized = false;
    }

    public List<String> write() {
        return List.copyOf(this.config);
    }

    public static String use() {
        return "Usage: id|namespace|#tag. Put \"!\" infront to exclude blocks. E.g. \"minecraft\", \"minecraft:dirt\" or \"#minecraft:planks\"";
    }
}

