/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public abstract class SingleFileResources
extends SimplePreparableReloadListener<JsonElement> {
    public static final String CONFIG_DIRECTORY = "improvedmobs/config";
    public static final Gson GSON = new Gson();
    public final ResourceLocation id;
    public final ResourceLocation file;
    protected final HolderLookup.Provider provider;

    public SingleFileResources(ResourceLocation id, HolderLookup.Provider provider) {
        this.id = id;
        this.file = FileToIdConverter.json((String)CONFIG_DIRECTORY).idToFile(id);
        this.provider = provider;
    }

    protected JsonElement prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        JsonElement jsonElement;
        block8: {
            BufferedReader reader = resourceManager.openAsReader(this.file);
            try {
                jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException | IllegalArgumentException exception) {
                    ImprovedMobs.LOGGER.error("Couldn't parse file {}", (Object)this.file, (Object)exception);
                    return JsonNull.INSTANCE;
                }
            }
            ((Reader)reader).close();
        }
        return jsonElement;
    }
}

