/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.utils;

import com.google.common.collect.AbstractIterator;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CustomBlockCollision
extends AbstractIterator<VoxelShape> {
    private final AABB box;
    private final CollisionContext context;
    private final Cursor3D cursor;
    private final BlockPos.MutableBlockPos pos;
    private final VoxelShape entityShape;
    private final CollisionGetter collisionGetter;
    private final boolean breakable;
    private final boolean ladder;
    @Nullable
    private BlockGetter cachedBlockGetter;
    private long cachedBlockGetterPos;
    private final LivingEntity entity;

    public CustomBlockCollision(CollisionGetter collisionGetter, @Nullable LivingEntity entity, AABB aABB, boolean breakable, boolean ladder) {
        this.entity = entity;
        this.context = entity == null ? CollisionContext.empty() : CollisionContext.of((Entity)entity);
        this.breakable = breakable;
        this.ladder = ladder;
        this.pos = new BlockPos.MutableBlockPos();
        this.entityShape = Shapes.create((AABB)aABB);
        this.collisionGetter = collisionGetter;
        this.box = aABB;
        int i = Mth.floor((double)(aABB.minX - 1.0E-7)) - 1;
        int j = Mth.floor((double)(aABB.maxX + 1.0E-7)) + 1;
        int k = Mth.floor((double)(aABB.minY - 1.0E-7)) - 1;
        int l = Mth.floor((double)(aABB.maxY + 1.0E-7)) + 1;
        int m = Mth.floor((double)(aABB.minZ - 1.0E-7)) - 1;
        int n = Mth.floor((double)(aABB.maxZ + 1.0E-7)) + 1;
        this.cursor = new Cursor3D(i, k, m, j, l, n);
    }

    @Nullable
    private BlockGetter getChunk(int i, int j) {
        BlockGetter blockGetter;
        int k = SectionPos.blockToSectionCoord((int)i);
        int l = SectionPos.blockToSectionCoord((int)j);
        long m = ChunkPos.asLong((int)k, (int)l);
        if (this.cachedBlockGetter != null && this.cachedBlockGetterPos == m) {
            return this.cachedBlockGetter;
        }
        this.cachedBlockGetter = blockGetter = this.collisionGetter.getChunkForCollisions(k, l);
        this.cachedBlockGetterPos = m;
        return blockGetter;
    }

    protected VoxelShape computeNext() {
        while (this.cursor.advance()) {
            BlockGetter blockGetter;
            int i = this.cursor.nextX();
            int j = this.cursor.nextY();
            int k = this.cursor.nextZ();
            int l = this.cursor.getNextType();
            if (l == 3 || (blockGetter = this.getChunk(i, k)) == null) continue;
            this.pos.set(i, j, k);
            BlockState blockState = blockGetter.getBlockState((BlockPos)this.pos);
            if (this.breakable && Config.CommonConfig.breakableBlocks.canBreak(blockState, (BlockPos)this.pos, blockGetter, (Entity)this.entity, this.context) || this.ladder && CrossPlatformStuff.INSTANCE.isClimbable(blockState, this.entity, (BlockPos)this.pos) || l == 1 && !blockState.hasLargeCollisionShape() || l == 2 && !blockState.is(Blocks.MOVING_PISTON)) continue;
            VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)this.collisionGetter, (BlockPos)this.pos, this.context);
            if (voxelShape == Shapes.block()) {
                if (!this.box.intersects((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0)) continue;
                return voxelShape.move((double)i, (double)j, (double)k);
            }
            VoxelShape voxelShape2 = voxelShape.move((double)i, (double)j, (double)k);
            if (!Shapes.joinIsNotEmpty((VoxelShape)voxelShape2, (VoxelShape)this.entityShape, (BooleanOp)BooleanOp.AND)) continue;
            return voxelShape2;
        }
        return (VoxelShape)this.endOfData();
    }
}

