/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.utils;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.config.equipment.EquipmentList;
import io.github.flemmli97.improvedmobs.common.config.values.StepExpressionConfig;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class Utils {
    public static final Function<Entity, ResourceLocation> ENTITY_ID = e -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)e.getType());
    public static final ResourceLocation ATTRIBUTE_ID = ImprovedMobs.modRes("attribute_modifiers");

    public static <T> boolean isInList(T entry, List<? extends String> list, boolean reverse, Function<T, ResourceLocation> mapper) {
        if (reverse) {
            return !Utils.isInList(entry, list, false, mapper);
        }
        ResourceLocation res = mapper.apply(entry);
        return list.contains(res.getPath()) || list.contains(res.toString());
    }

    public static boolean canHarvest(BlockState block, ItemStack item) {
        if (Config.CommonConfig.ignoreHarvestLevel) {
            return true;
        }
        return item.isCorrectToolForDrops(block) || !block.requiresCorrectToolForDrops();
    }

    public static void equipArmor(Mob living, double difficulty, VariableMap map) {
        if ((double)living.getRandom().nextFloat() < Config.CommonConfig.equipmentChance.get(map)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                boolean shouldAdd;
                if (slot.getType() == EquipmentSlot.Type.HAND) continue;
                boolean bl = shouldAdd = slot == EquipmentSlot.HEAD || (double)living.getRandom().nextFloat() < Config.CommonConfig.additionalEquipmentChance.get(map);
                if (!shouldAdd || !living.getItemBySlot(slot).isEmpty()) continue;
                ItemStack equip = EquipmentList.getEquipment(living, slot, difficulty);
                if ((double)living.getRandom().nextFloat() < Config.CommonConfig.randomTrimChance.get(map)) {
                    RegistryAccess.Frozen registryAccess = living.getServer().registryAccess();
                    Optional trim = registryAccess.registry(Registries.TRIM_MATERIAL).flatMap(r -> r.getRandom(living.getRandom()));
                    Optional pattern = living.getServer().registryAccess().registry(Registries.TRIM_PATTERN).flatMap(r -> r.getRandom(living.getRandom()));
                    if (trim.isPresent() && pattern.isPresent()) {
                        equip.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)trim.get(), (Holder)pattern.get()));
                    }
                }
                if (equip.isEmpty()) continue;
                living.setDropChance(slot, (float)Config.CommonConfig.dropChance.get(map));
                living.setItemSlot(slot, equip);
            }
        }
    }

    public static void equipHeld(Mob living, double difficulty, VariableMap map) {
        ItemStack stack;
        if ((double)living.getRandom().nextFloat() < Config.CommonConfig.mainHandChance.get(map) && living.getMainHandItem().isEmpty()) {
            stack = EquipmentList.getEquipment(living, EquipmentSlot.MAINHAND, difficulty);
            living.setDropChance(EquipmentSlot.MAINHAND, (float)Config.CommonConfig.dropChance.get(map));
            living.setItemSlot(EquipmentSlot.MAINHAND, stack);
        }
        if (living instanceof AbstractPiglin) {
            return;
        }
        if ((double)living.getRandom().nextFloat() < Config.CommonConfig.offHandChance.get(map) && living.getOffhandItem().isEmpty()) {
            stack = EquipmentList.getEquipment(living, EquipmentSlot.OFFHAND, difficulty);
            living.setDropChance(EquipmentSlot.OFFHAND, (float)Config.CommonConfig.dropChance.get(map));
            living.setItemSlot(EquipmentSlot.OFFHAND, stack);
        }
    }

    public static void enchantGear(Mob living, double difficulty, VariableMap map) {
        StepExpressionConfig.Value val = Config.CommonConfig.enchantCalc.get(difficulty);
        int level = (int)val.expression().get(map);
        if (level == 0) {
            return;
        }
        for (EquipmentSlot entityequipmentslot : EquipmentSlot.values()) {
            ItemStack itemstack = living.getItemBySlot(entityequipmentslot);
            if (itemstack.isEnchanted() || itemstack.isEmpty() || !((double)living.getRandom().nextFloat() < Config.CommonConfig.enchantChance.get(map))) continue;
            RegistryAccess registryAccess = living.registryAccess();
            EnchantmentHelper.enchantItem((RandomSource)living.getRandom(), (ItemStack)itemstack, (int)level, registryAccess.registryOrThrow(Registries.ENCHANTMENT).holders().filter(r -> Config.CommonConfig.enchantWhitelist == Config.CommonConfig.enchantBlacklist.contains(r.key().location().toString())).map(r -> r));
        }
    }

    public static float getBlockStrength(Mob entityLiving, BlockState state, Level level, BlockPos pos) {
        float hardness = level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        ItemStack main = entityLiving.getMainHandItem();
        ItemStack off = entityLiving.getOffhandItem();
        if (Utils.canHarvest(state, main)) {
            float offSpeed;
            float speed = Utils.getBreakSpeed(entityLiving, main, state);
            if (Utils.canHarvest(state, off) && (offSpeed = Utils.getBreakSpeed(entityLiving, off, state)) > speed) {
                speed = offSpeed;
            }
            return speed / hardness / 30.0f;
        }
        if (Utils.canHarvest(state, off)) {
            return Utils.getBreakSpeed(entityLiving, off, state) / hardness / 30.0f;
        }
        return Utils.getBreakSpeed(entityLiving, main, state) / hardness / 100.0f;
    }

    public static float getBreakSpeed(Mob entity, ItemStack stack, BlockState state) {
        float f = stack.getDestroySpeed(state);
        if (f > 1.0f && entity.getAttributes().hasAttribute(Attributes.MINING_EFFICIENCY)) {
            f += (float)entity.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)entity)) {
            f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            switch (entity.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0: {
                    f *= 0.3f;
                    break;
                }
                case 1: {
                    f *= 0.09f;
                    break;
                }
                case 2: {
                    f *= 0.0027f;
                    break;
                }
                default: {
                    f *= 8.1E-4f;
                }
            }
        }
        if (entity.isEyeInFluid(FluidTags.WATER) && entity.getAttribute(Attributes.SUBMERGED_MINING_SPEED) != null) {
            f *= (float)entity.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!entity.onGround()) {
            f /= 5.0f;
        }
        return f;
    }
}

