/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.mixin;

import io.github.flemmli97.improvedmobs.common.utils.EntityFlags;
import io.github.flemmli97.improvedmobs.mixinhelper.TNTExtension;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PrimedTnt.class})
public abstract class TNTEntityMixin
extends Entity
implements TNTExtension {
    private TNTEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Shadow
    protected abstract void explode();

    @Inject(method={"tick"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyExplosion(CallbackInfo info) {
        PrimedTnt tnt = (PrimedTnt)this;
        if (EntityFlags.get((Entity)tnt).isThrownEntity && tnt.getFuse() == 2) {
            info.cancel();
            tnt.remove(Entity.RemovalReason.KILLED);
            if (!tnt.level().isClientSide) {
                this.explode();
            }
        }
    }

    @Override
    public void improvedMobs$shootFromEntity(Entity shooter, float pitch, float yaw, float delta, float velocity, float accuracy) {
        PrimedTnt tnt = (PrimedTnt)this;
        float x = -Mth.sin((float)(yaw * (float)Math.PI / 180.0f)) * Mth.cos((float)(pitch * (float)Math.PI / 180.0f));
        float y = -Mth.sin((float)((pitch + delta) * (float)Math.PI / 180.0f));
        float z = Mth.cos((float)(yaw * (float)Math.PI / 180.0f)) * Mth.cos((float)(pitch * (float)Math.PI / 180.0f));
        Vec3 newMotion = new Vec3((double)x, (double)y, (double)z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)accuracy, this.random.nextGaussian() * (double)0.0075f * (double)accuracy, this.random.nextGaussian() * (double)0.0075f * (double)accuracy).scale((double)velocity);
        tnt.setDeltaMovement(newMotion);
        double f3 = Math.sqrt(newMotion.x * newMotion.x + newMotion.z * newMotion.z);
        tnt.setYRot((float)(Mth.atan2((double)newMotion.x, (double)newMotion.z) * 57.2957763671875));
        tnt.setXRot((float)(Mth.atan2((double)newMotion.y, (double)f3) * 57.2957763671875));
        tnt.yRotO = tnt.getYRot();
        tnt.xRotO = tnt.getXRot();
        Vec3 shooterMotion = shooter.getDeltaMovement();
        tnt.setDeltaMovement(tnt.getDeltaMovement().add(shooterMotion.x, shooter.onGround() ? 0.0 : shooterMotion.y, shooterMotion.z));
    }
}

