/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.neoforge.events;

import com.mojang.brigadier.CommandDispatcher;
import io.github.flemmli97.improvedmobs.common.commands.ImprovedMobsCommand;
import io.github.flemmli97.improvedmobs.common.config.holder.ConfigLoader;
import io.github.flemmli97.improvedmobs.common.events.EventCalls;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class EventHandler {
    @SubscribeEvent
    public void worldLoad(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            ConfigLoader.serverInit(serverLevel);
        }
    }

    @SubscribeEvent
    public void commands(RegisterCommandsEvent event) {
        ImprovedMobsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onEntityLoad(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            EventCalls.onEntityLoad(mob);
        }
    }

    @SubscribeEvent
    public void hurtEvent(LivingDamageEvent.Pre e) {
        e.setNewDamage(EventCalls.hurtEvent(e.getEntity(), e.getSource(), e.getNewDamage()));
    }

    @SubscribeEvent
    public void attackEvent(LivingIncomingDamageEvent e) {
        if (EventCalls.onAttackEvent(e.getEntity(), e.getSource())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void openTile(PlayerInteractEvent.RightClickBlock e) {
        EventCalls.openTile(e.getEntity(), e.getPos());
    }

    @SubscribeEvent
    public void equipPet(PlayerInteractEvent.EntityInteract e) {
        if (EventCalls.equipPet(e.getEntity(), e.getHand(), e.getTarget())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent e) {
        Projectile proj;
        Entity entity = e.getEntity();
        if (entity instanceof Projectile && EventCalls.projectileImpact(proj = (Projectile)entity, e.getRayTraceResult())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void explosion(ExplosionEvent.Detonate event) {
        EventCalls.explosion(event.getExplosion(), event.getExplosion().getDirectSourceEntity(), event.getAffectedEntities());
    }
}

