/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.datapack;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class EntityTypeValue {
    public static final Codec<EntityTypeValue> CODEC = new Codec<EntityTypeValue>(){
        private static final Codec<class_6862<class_1299<?>>> TAG_CODEC = class_6862.method_40093((class_5321)class_7924.field_41266);
        private static final Codec<class_1299<?>> TYPE_CODEC = class_7923.field_41177.method_39673();
        private static final Codec<String> NAME_SPACE_CODEC = Codec.STRING.validate(s -> class_2960.method_20209((String)s) ? DataResult.success((Object)s) : DataResult.error(() -> "Invalid namespace string " + s));

        public <T> DataResult<Pair<EntityTypeValue, T>> decode(DynamicOps<T> ops, T input) {
            DataResult res = TAG_CODEC.decode(ops, input);
            if (res.isSuccess()) {
                return res.map(v -> v.mapFirst(EntityTypeValue::ofTag));
            }
            DataResult res2 = TYPE_CODEC.decode(ops, input);
            if (res2.isSuccess()) {
                return res2.map(v -> v.mapFirst(EntityTypeValue::ofType));
            }
            DataResult res3 = NAME_SPACE_CODEC.decode(ops, input);
            if (res3.isSuccess()) {
                return res3.map(v -> v.mapFirst(EntityTypeValue::ofNamespace));
            }
            return DataResult.error(() -> "Unable to decode input " + String.valueOf(input));
        }

        public <T> DataResult<T> encode(EntityTypeValue input, DynamicOps<T> ops, T prefix) {
            if (input.tag != null) {
                return TAG_CODEC.encode(input.tag, ops, prefix);
            }
            if (input.type != null) {
                return TYPE_CODEC.encode(input.type, ops, prefix);
            }
            if (input.modid != null) {
                return NAME_SPACE_CODEC.encode((Object)input.modid, ops, prefix);
            }
            return DataResult.error(() -> "Unable to encode value " + String.valueOf(input));
        }
    };
    @Nullable
    private final class_6862<class_1299<?>> tag;
    @Nullable
    private final class_1299<?> type;
    @Nullable
    private final String modid;

    private EntityTypeValue(class_6862<class_1299<?>> tag, class_1299<?> type, String modid) {
        this.tag = tag;
        this.type = type;
        this.modid = modid;
    }

    public static EntityTypeValue ofTag(class_6862<class_1299<?>> tag) {
        return new EntityTypeValue(tag, null, null);
    }

    public static EntityTypeValue ofType(class_1299<?> type) {
        return new EntityTypeValue(null, type, null);
    }

    public static EntityTypeValue ofNamespace(String modid) {
        return new EntityTypeValue(null, null, modid);
    }

    public boolean isTag(class_6880<class_1299<?>> type) {
        return this.tag != null && type.method_40220(this.tag);
    }

    public boolean isDirect(class_6880<class_1299<?>> type) {
        return this.type != null && this.type == type.comp_349();
    }

    public boolean isNamespace(class_6880<class_1299<?>> type) {
        return ((class_5321)type.method_40230().orElseThrow()).method_29177().method_12836().equals(this.modid);
    }
}

