/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.datapack;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import io.github.flemmli97.improvedmobs.api.item.ItemUseRegistry;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.config.equipment.EquipmentList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class ItemUseLookupManager
implements class_3302 {
    public static final class_2960 ID = ImprovedMobs.modRes("item_use_lookup");
    private static ItemUseLookupManager INSTANCE;
    private Map<class_1792, Collection<ItemUseHandler>> lookup = ImmutableMap.of();
    private final class_7225.class_7874 provider;

    private ItemUseLookupManager(class_7225.class_7874 provider) {
        this.provider = provider;
    }

    public static ItemUseLookupManager create(class_7225.class_7874 provider) {
        INSTANCE = new ItemUseLookupManager(provider);
        return ItemUseLookupManager.getInstance();
    }

    public static ItemUseLookupManager getInstance() {
        return INSTANCE;
    }

    public Collection<ItemUseHandler> get(class_1792 item) {
        return this.lookup.getOrDefault(item, Collections.emptyList());
    }

    public Pair<ItemUseHandler, class_1268> get(class_1308 entity) {
        class_1799 heldMain = entity.method_6047();
        class_1799 heldOff = entity.method_6079();
        if (heldMain.method_7909() instanceof class_1744 && heldOff.method_7909() instanceof class_1753) {
            entity.method_5673(class_1304.field_6173, heldOff.method_7972());
            entity.method_5673(class_1304.field_6171, heldMain.method_7972());
            heldMain = entity.method_6047();
            heldOff = entity.method_6079();
        }
        class_1268 hand = class_1268.field_5808;
        class_1799 mainCheck = heldMain;
        ItemUseHandler ai = this.get(heldMain.method_7909()).stream().filter(handler -> handler.canUse((class_1309)entity, mainCheck)).findFirst().orElse(null);
        if (ai == null || ai.preferredHand() == ItemUseHandler.PreferredHand.OFFHAND || ItemUseLookupManager.blockedAI(entity, heldMain.method_7909())) {
            class_1799 offCheck = heldOff;
            ai = this.get(heldOff.method_7909()).stream().filter(handler -> handler.canUse((class_1309)entity, offCheck)).findFirst().orElse(null);
            if (ai != null) {
                if (ai.preferredHand() == ItemUseHandler.PreferredHand.MAINHAND || ItemUseLookupManager.blockedAI(entity, heldOff.method_7909())) {
                    ai = null;
                } else {
                    hand = class_1268.field_5810;
                }
            }
        }
        return Pair.of((Object)ai, (Object)hand);
    }

    private static boolean blockedAI(class_1308 entity, class_1792 item) {
        return Config.CommonConfig.itemuseWhitelist && !Config.CommonConfig.itemuseBlacklist.contains(class_7923.field_41178.method_10221((Object)item).toString()) || Config.CommonConfig.itemuseBlacklist.contains(class_7923.field_41178.method_10221((Object)item).toString()) || Config.CommonConfig.entityItemConfig.preventUse((class_1297)entity, item);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (class_1792 item : class_7923.field_41178) {
                List<ItemUseHandler> handlers = ItemUseRegistry.getAll().stream().filter(handler -> handler.matches(item)).toList();
                if (handlers.isEmpty()) continue;
                builder.put((Object)item, handlers);
            }
            this.lookup = builder.build();
        }).thenRun(() -> EquipmentList.initEquip(this.provider, this))).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0));
    }
}

