/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.common.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.common.network.PacketHandler;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.Collection;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ImprovedMobsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"improvedmobs").executes(ImprovedMobsCommand::getDifficulty)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"difficulty").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::setDifficultyPlayer)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::addDifficultyPlayer)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::setDifficulty)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"val", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ImprovedMobsCommand::addDifficulty)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"pause").then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<class_2168>)src, class_2191.method_9330((CommandContext)src, (String)"players"), true))))).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<class_2168>)src, null, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unpause").then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<class_2168>)src, class_2191.method_9330((CommandContext)src, (String)"players"), false))))).executes(src -> ImprovedMobsCommand.pauseDifficulty((CommandContext<class_2168>)src, null, false)))).then(class_2170.method_9247((String)"simulate").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"steps", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(src -> ImprovedMobsCommand.simulateDifficulty((CommandContext<class_2168>)src, class_2191.method_9330((CommandContext)src, (String)"players"), IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))).executes(src -> ImprovedMobsCommand.simulateDifficulty((CommandContext<class_2168>)src, null, IntegerArgumentType.getInteger((CommandContext)src, (String)"steps")))))));
    }

    private static int setDifficulty(CommandContext<class_2168> src) {
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        data.setDifficulty(DoubleArgumentType.getDouble(src, (String)"val"), ((class_2168)src.getSource()).method_9211());
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty set to " + data.getDifficulty())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int addDifficulty(CommandContext<class_2168> src) {
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        data.addDifficulty(DoubleArgumentType.getDouble(src, (String)"val"), ((class_2168)src.getSource()).method_9211());
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty set to " + data.getDifficulty())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int setDifficultyPlayer(CommandContext<class_2168> src) throws CommandSyntaxException {
        Collection profs = class_2191.method_9330(src, (String)"players");
        MinecraftServer server = ((class_2168)src.getSource()).method_9211();
        for (GameProfile prof : profs) {
            class_3222 player = server.method_3760().method_14602(prof.getId());
            PlayerDifficulty data = (PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player);
            data.setDifficultyLevel(DoubleArgumentType.getDouble(src, (String)"val"));
            CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        }
        return profs.size();
    }

    private static int addDifficultyPlayer(CommandContext<class_2168> src) throws CommandSyntaxException {
        Collection profs = class_2191.method_9330(src, (String)"players");
        MinecraftServer server = ((class_2168)src.getSource()).method_9211();
        for (GameProfile prof : profs) {
            class_3222 player = server.method_3760().method_14602(prof.getId());
            PlayerDifficulty data = (PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player);
            data.setDifficultyLevel(data.getDifficultyLevel() + DoubleArgumentType.getDouble(src, (String)"val"));
            CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        }
        return profs.size();
    }

    private static int getDifficulty(CommandContext<class_2168> src) throws CommandSyntaxException {
        double diff;
        if (Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL) {
            diff = DifficultyData.get(((class_2168)src.getSource()).method_9211()).getDifficulty();
        } else {
            class_3222 player = ((class_2168)src.getSource()).method_9207();
            diff = ((PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player)).getDifficultyLevel();
        }
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty: " + diff)).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int pauseDifficulty(CommandContext<class_2168> src, Collection<GameProfile> profs, boolean pause) throws CommandSyntaxException {
        if (profs != null) {
            MinecraftServer server = ((class_2168)src.getSource()).method_9211();
            for (GameProfile prof : profs) {
                class_3222 player = server.method_3760().method_14602(prof.getId());
                PlayerDifficulty data = (PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player);
                data.setPaused(pause);
            }
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty " + (pause ? "paused" : "unpaused") + " for given players")).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
            return profs.size();
        }
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        data.setPaused(pause);
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)("Difficulty " + (pause ? "paused" : "unpaused"))).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }

    private static int simulateDifficulty(CommandContext<class_2168> src, Collection<GameProfile> profs, int steps) {
        VariableMap vars = new VariableMap();
        if (profs != null) {
            MinecraftServer server = ((class_2168)src.getSource()).method_9211();
            for (GameProfile prof : profs) {
                class_3222 player = server.method_3760().method_14602(prof.getId());
                PlayerDifficulty data = (PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get((Object)player);
                Config.apply(vars, (class_1309)player, 0.0);
                for (int i = steps; i > 0; --i) {
                    data.increaseCurrent(vars);
                }
                CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
            }
            ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Simulated %s difficulty steps for given players", steps)).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
            return profs.size();
        }
        DifficultyData data = DifficultyData.get(((class_2168)src.getSource()).method_9211());
        vars.clear();
        for (int i = steps; i > 0; --i) {
            data.increaseCurrent(vars);
        }
        ((class_2168)src.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Simulated %s difficulty steps globally. Now at %s", steps, data.getDifficulty())).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), true);
        return 1;
    }
}

