/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.equipment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.config.equipment.OptionalItemStack;
import net.minecraft.class_1799;
import net.minecraft.class_3532;

public class WeightedItemstack
implements Comparable<WeightedItemstack> {
    public static final Codec<WeightedItemstack> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)OptionalItemStack.CODEC.fieldOf("value").forGetter(d -> d.item), (App)Codec.INT.fieldOf("weight").forGetter(d -> d.weight), (App)Codec.FLOAT.fieldOf("quality").forGetter(d -> Float.valueOf(d.quality))).apply((Applicative)inst, WeightedItemstack::new));
    private final OptionalItemStack item;
    private final class_1799 stack;
    private final int weight;
    private final float quality;

    public WeightedItemstack(OptionalItemStack item, int itemWeight, float quality) {
        this.item = item;
        this.stack = item.asStack();
        this.weight = itemWeight;
        this.quality = quality;
    }

    public class_1799 getItem() {
        return this.stack.method_7972();
    }

    public int weight() {
        return this.weight;
    }

    public float quality() {
        return this.quality;
    }

    public int getWeight(double modifier) {
        return Math.max(this.weight + class_3532.method_15357((double)(modifier * (double)this.quality)), 0);
    }

    public boolean valid() {
        return !this.stack.method_7960() && (this.weight() > 0 || this.quality() > 0.0f) && this.isEnabled();
    }

    public boolean isEnabled() {
        if (Config.CommonConfig.equipmentModWhitelist) {
            return Config.CommonConfig.equipmentModBlacklist.contains(this.item.item().method_40237().method_29177().method_12836());
        }
        return !Config.CommonConfig.equipmentModBlacklist.contains(this.item.item().method_40237().method_29177().method_12836());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WeightedItemstack) {
            WeightedItemstack other = (WeightedItemstack)obj;
            return class_1799.method_7973((class_1799)this.stack, (class_1799)other.stack);
        }
        return false;
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    @Override
    public int compareTo(WeightedItemstack o) {
        return this.item.item().method_55840().compareTo(o.item.item().method_55840());
    }

    public String toString() {
        return String.format("Item: %s; Weight: %s, Quality: %s", this.item.item().method_55840(), this.weight, Float.valueOf(this.quality));
    }
}

