/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import io.github.flemmli97.improvedmobs.api.datapack.EntityOverridesManager;
import io.github.flemmli97.improvedmobs.common.config.Config;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BreakableBlocks {
    private final List<String> config = new ArrayList<String>();
    private boolean initialized;
    private final Set<class_2248> blocks = new HashSet<class_2248>();

    public BreakableBlocks(String ... defaultVal) {
        this.config.addAll(List.of(defaultVal));
    }

    public boolean canBreak(class_2680 state, class_2338 pos, class_1922 level, @Nullable class_1297 entity, class_3726 ctx) {
        class_1308 mob;
        this.initialize();
        if (!Config.CommonConfig.idleBreak && entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() == null) {
            return false;
        }
        if (state.method_26194(level, pos, ctx).method_1110()) {
            return false;
        }
        if (!Config.CommonConfig.breakBlockEntities && state.method_31709()) {
            return false;
        }
        if (entity instanceof class_1308) {
            mob = (class_1308)entity;
            EntityOverridesManager.OverrideState override = EntityOverridesManager.getInstance().canBreak((class_1309)mob, state);
            if (override == EntityOverridesManager.OverrideState.ALLOW) {
                return true;
            }
            if (override == EntityOverridesManager.OverrideState.DENY) {
                return false;
            }
        }
        if (Config.CommonConfig.breakingAsBlacklist) {
            return !this.blocks.contains(state.method_26204());
        }
        return this.blocks.contains(state.method_26204());
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        class_7923.field_41175.method_40270().forEach(block -> {
            boolean contains;
            class_2960 id = block.method_40237().method_29177();
            boolean bl = contains = this.config.contains(id.toString()) || this.config.contains(id.method_12836()) || block.method_40228().anyMatch(tag -> this.config.contains("#" + String.valueOf(tag.comp_327())));
            if (contains) {
                boolean blocked;
                boolean bl2 = blocked = this.config.contains("!" + String.valueOf(id)) || this.config.contains("!" + id.method_12836()) || block.method_40228().anyMatch(tag -> this.config.contains("!#" + String.valueOf(tag.comp_327())));
                if (!blocked) {
                    this.blocks.add((class_2248)block.comp_349());
                }
            }
        });
    }

    public void tagReloaded() {
        this.blocks.clear();
        this.initialized = false;
        this.initialize();
    }

    public void read(List<String> arr) {
        this.config.clear();
        this.config.addAll(arr);
        this.blocks.clear();
        this.initialized = false;
    }

    public List<String> write() {
        return List.copyOf(this.config);
    }

    public static String use() {
        return "Usage: id|namespace|#tag. Put \"!\" infront to exclude blocks. E.g. \"minecraft\", \"minecraft:dirt\" or \"#minecraft:planks\"";
    }
}

