/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.DifficultyFeatures;
import io.github.flemmli97.improvedmobs.api.datapack.EntityOverridesManager;
import io.github.flemmli97.improvedmobs.common.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class EntityFeatureConfig {
    private final List<String> config = new ArrayList<String>();
    private boolean initialized;
    private final Map<class_1299<?>, EnumSet<DifficultyFeatures>> features = new HashMap();

    public void initDefault(class_1937 level) {
        this.features.clear();
        class_7923.field_41177.method_40270().forEach(type -> {
            try {
                class_1297 entity = ((class_1299)type.comp_349()).method_5883(level);
                if (entity instanceof class_1308 && !(entity instanceof class_1569)) {
                    this.config.add(type.method_55840());
                }
            }
            catch (Exception e) {
                ImprovedMobs.LOGGER.error("Error during default entity config for EntityType {}, skipping this type. Cause: {}", (Object)type.method_40237(), (Object)e.getMessage());
            }
        });
    }

    public boolean isDisabledFor(class_1308 living, DifficultyFeatures flag) {
        if (Config.CommonConfig.featureBlacklist.contains((Object)flag)) {
            return true;
        }
        this.initialize();
        EntityOverridesManager.OverrideState override = EntityOverridesManager.getInstance().isEnabled((class_1309)living, flag);
        if (override == EntityOverridesManager.OverrideState.ALLOW) {
            return false;
        }
        if (override == EntityOverridesManager.OverrideState.DENY) {
            return true;
        }
        boolean reverse = Config.CommonConfig.featureWhitelist.contains((Object)flag);
        EnumSet<DifficultyFeatures> set = this.features.get(living.method_5864());
        if (set != null) {
            return reverse ^ set.contains((Object)DifficultyFeatures.REVERSE) ^ (set.contains((Object)DifficultyFeatures.ALL) || set.contains((Object)flag));
        }
        return reverse;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap direct = new HashMap();
        HashMap<class_1299, EnumSet> tags = new HashMap<class_1299, EnumSet>();
        HashMap<class_1299, EnumSet> namespace = new HashMap<class_1299, EnumSet>();
        class_7923.field_41177.method_40270().forEach(type -> this.config.forEach(val -> {
            EnumSet<DifficultyFeatures> set;
            String[] subs = val.replace(" ", "").split("\\|");
            if (subs.length == 1) {
                set = EnumSet.of(DifficultyFeatures.ALL);
            } else {
                set = EnumSet.noneOf(DifficultyFeatures.class);
                for (int i = 1; i < subs.length; ++i) {
                    set.add(DifficultyFeatures.valueOf(subs[i]));
                }
            }
            String entity = subs[0];
            if (entity.startsWith("#")) {
                if (type.method_40220(class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)class_2960.method_60654((String)entity.substring(1))))) {
                    tags.put((class_1299)type.comp_349(), set);
                }
            } else if (type.method_55840().equals(entity)) {
                direct.put((class_1299)type.comp_349(), set);
            } else if (type.method_40237().method_29177().method_12836().equals(entity)) {
                namespace.put((class_1299)type.comp_349(), set);
            }
        }));
        tags.forEach((type, features) -> {
            if (!direct.containsKey(type)) {
                direct.put(type, features);
            }
        });
        namespace.forEach((type, features) -> {
            if (!direct.containsKey(type)) {
                direct.put(type, features);
            }
        });
        this.features.putAll(direct);
    }

    public void tagReloaded() {
        this.features.clear();
        this.initialized = false;
        this.initialize();
    }

    public void read(List<String> config) {
        this.config.clear();
        this.config.addAll(config);
        this.features.clear();
        this.initialized = false;
    }

    public List<String> write() {
        return List.copyOf(this.config);
    }

    public static String use() {
        CharSequence[] str = new String[]{"Mods can override this now with a datapack! Check for the message 'Following entity overrides are loaded' in your logs to see any overrides", "Entities added here will be blacklisted from that feature. Usage:", "<entity registry name | namespace | #tag> followed by any of:", "[" + Arrays.toString((Object[])DifficultyFeatures.values()) + "].", "Having nothing is equal to ALL. Use REVERSE to reverse all features. Some features do nothing for certain mobs!", "Examples (without <>):", "<minecraft:sheep> (equal to minecraft:sheep|ALL) excludes sheeps from all modifications", "<minecraft:sheep|REVERSE|ATTRIBUTES> add sheep to attributes modification only", "<#minecraft:raiders|ATTRIBUTES> will make all raiders be excluded from attribute modifications", "<minecraft:sheep|ATTRIBUTES> will make sheeps be excluded from attribute modifications", "<minecraft> disables everything for all vanilla entities"};
        return String.join((CharSequence)"\n", str);
    }
}

