/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.common.config.values.ExpressionConfig;
import io.github.flemmli97.tenshilib.common.utils.SearchUtils;
import java.util.ArrayList;
import java.util.List;

public class StepExpressionConfig {
    public static final Value DIFFICULTY_DEFAULT = new Value(0.0, new ExpressionConfig("difficulty + 0.01"));
    public static final Value ENCHANT_DEFAULT = new Value(0.0, new ExpressionConfig("0"));
    private final Value defaultValue;
    private final List<Value> values = new ArrayList<Value>();

    public StepExpressionConfig(Value defaultValue, Value ... values) {
        this.defaultValue = defaultValue;
        this.values.addAll(List.of(values));
    }

    public Value get(double difficulty) {
        return (Value)SearchUtils.searchInfFunc(this.values, v -> Double.compare(v.requiredDifficulty(), difficulty), (Object)this.defaultValue);
    }

    public void read(List<String> config) {
        try {
            ArrayList<Value> list = new ArrayList<Value>();
            for (String s : config) {
                String[] parts = s.split(";");
                if (parts.length != 2) continue;
                list.add(new Value(Double.parseDouble(parts[0]), new ExpressionConfig(parts[1])));
            }
            list.sort(null);
            this.values.clear();
            this.values.addAll(list);
        }
        catch (IllegalStateException e) {
            ImprovedMobs.LOGGER.error("Unable to parse expression from config: {}", config, (Object)e);
        }
    }

    public List<String> write() {
        ArrayList<String> list = new ArrayList<String>();
        this.values.forEach(v -> list.add(v.write()));
        return list;
    }

    public record Value(double requiredDifficulty, ExpressionConfig expression) implements Comparable<Value>
    {
        public Value(double requiredDifficulty, String expression) {
            this(requiredDifficulty, new ExpressionConfig(expression));
        }

        public String write() {
            return String.format("%s;%s", this.requiredDifficulty, this.expression.write());
        }

        @Override
        public int compareTo(Value o) {
            return Double.compare(this.requiredDifficulty, o.requiredDifficulty);
        }
    }
}

