/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class TargetMapConfig {
    private final List<String> config = new ArrayList<String>();
    private boolean initialized;
    private final Map<class_1299<?>, Predicate<class_1299<?>>> map = new HashMap();

    @Nullable
    public Predicate<class_1299<?>> get(class_1299<?> type) {
        this.initialize();
        return this.map.get(type);
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap<class_1299, PredicateBuilder> direct = new HashMap<class_1299, PredicateBuilder>();
        HashMap<class_6885, PredicateBuilder> tags = new HashMap<class_6885, PredicateBuilder>();
        for (String value : this.config) {
            Consumer<Either> cons;
            class_6862 tag;
            String[] sub = value.replace(" ", "").split("-");
            if (sub.length < 2) continue;
            String source = sub[0];
            if (source.startsWith("#")) {
                tag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)source.substring(1)));
                cons = either -> class_7923.field_41177.method_40266(tag).ifPresent(named -> either.ifLeft(t -> tags.computeIfAbsent((class_6885)named, key -> new PredicateBuilder()).appendTag((class_6862<class_1299<?>>)t)).ifRight(t -> tags.computeIfAbsent((class_6885)named, key -> new PredicateBuilder()).appendType((class_1299<?>)t)));
            } else {
                Optional type2 = class_7923.field_41177.method_17966(class_2960.method_60654((String)source));
                if (type2.isEmpty()) continue;
                cons = either -> either.ifLeft(t -> direct.computeIfAbsent((class_1299)type2.get(), key -> new PredicateBuilder()).appendTag((class_6862<class_1299<?>>)t)).ifRight(t -> direct.computeIfAbsent((class_1299)type2.get(), key -> new PredicateBuilder()).appendType((class_1299<?>)t));
            }
            if (sub[1].startsWith("#")) {
                tag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)sub[1].substring(1)));
                if (!class_7923.field_41177.method_40266(tag).isPresent()) continue;
                cons.accept(Either.left((Object)tag));
                continue;
            }
            class_1299 target = class_7923.field_41177.method_17966(class_2960.method_60654((String)sub[1])).orElse(null);
            if (target == null) {
                ImprovedMobs.LOGGER.error("Entity {} does not exist/is not registered", (Object)sub[1]);
                continue;
            }
            cons.accept(Either.right((Object)target));
        }
        direct.forEach((type, pred) -> this.map.put((class_1299<?>)type, pred.build()));
        tags.forEach((set, pred) -> set.forEach(h -> this.map.put((class_1299)h.comp_349(), pred.build())));
    }

    public void tagReloaded() {
        this.map.clear();
        this.initialized = false;
        this.initialize();
    }

    public void read(List<String> config) {
        this.map.clear();
        this.config.clear();
        this.config.addAll(config);
        this.initialized = false;
    }

    public List<String> write() {
        return List.copyOf(this.config);
    }

    public static String[] use() {
        return new String[]{"List for of pairs containing which mobs auto target others.", "Syntax is <source-target> where", "  source: is the mob that should target something. This can be either an entity or a tag", "  target: the mob source should target. This can be either an entity or a tag", "Examples: ", "minecraft:zombie-minecraft:skeleton makes all zombies target skeletons", "minecraft:zombie-#minecraft:raiders makes all zombies target raid entities"};
    }

    private static class PredicateBuilder {
        private final List<class_1299<?>> direct = new ArrayList();
        private final List<class_6862<class_1299<?>>> tags = new ArrayList();

        private PredicateBuilder() {
        }

        public void appendType(class_1299<?> type) {
            this.direct.add(type);
        }

        public void appendTag(class_6862<class_1299<?>> tag) {
            this.tags.add(tag);
        }

        public Predicate<class_1299<?>> build() {
            ImmutableSet direct = ImmutableSet.copyOf(this.direct);
            ImmutableList tags = ImmutableList.copyOf(this.tags);
            return arg_0 -> PredicateBuilder.lambda$build$0((Set)direct, (List)tags, arg_0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static /* synthetic */ boolean lambda$build$0(Set direct, List tags, class_1299 type) {
            if (direct.contains(type)) return true;
            if (!tags.stream().anyMatch(arg_0 -> ((class_1299)type).method_20210(arg_0))) return false;
            return true;
        }
    }
}

