/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.difficulty;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyFetcher;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.config.values.DifficultyExpressionConfig;
import io.github.flemmli97.improvedmobs.common.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class DifficultyData
extends class_18 {
    private static final String IDENTIFIER = "Difficulty";
    private static final class_18.class_8645<DifficultyData> FACTORY = new class_18.class_8645(DifficultyData::new, DifficultyData::new, class_4284.field_19212);
    private int difficultyIndex;
    private double difficultyLevel;
    private long prevTime;
    private boolean paused;

    public DifficultyData() {
    }

    private DifficultyData(class_2487 tag, class_7225.class_7874 provider) {
        this.load(tag);
    }

    public static DifficultyData get(MinecraftServer server) {
        return (DifficultyData)server.method_30002().method_17983().method_17924(FACTORY, IDENTIFIER);
    }

    public static double getDifficulty(class_1937 level, class_1309 entity) {
        if (!(level instanceof class_3218)) {
            return 0.0;
        }
        class_3218 serverLevel = (class_3218)level;
        return DifficultyFetcher.getDifficulty(serverLevel, entity.method_19538());
    }

    public static List<class_1657> playersIn(class_1924 getter, class_243 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (class_1657 player : getter.method_18456()) {
            if (!player.method_19538().method_24802((class_2374)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public void increaseDifficulty(boolean shouldIncrease, long time, MinecraftServer server) {
        if (shouldIncrease) {
            VariableMap vars = new VariableMap();
            if (!this.paused) {
                this.increaseCurrent(vars);
            }
            server.method_3760().method_14571().forEach(player -> {
                PlayerDifficulty data = (PlayerDifficulty)ImprovedMobsAttachments.PLAYER_DIFFICULTY.get().get(player);
                if (!data.paused()) {
                    Config.apply(vars, (class_1309)player, data.getDifficultyLevel());
                    data.increaseCurrent(vars);
                }
            });
        }
        this.prevTime = time;
        this.method_80();
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
    }

    public void increaseCurrent(VariableMap vars) {
        double current = this.getDifficulty();
        Pair<Integer, DifficultyExpressionConfig.Value> difficulty = Config.CommonConfig.difficultyIncrease.get(current, this.difficultyIndex);
        this.difficultyIndex = (Integer)difficulty.getFirst();
        this.difficultyLevel = (float)((DifficultyExpressionConfig.Value)difficulty.getSecond()).expression().get(vars.setVariable("difficulty", current));
    }

    public void updateTime(MinecraftServer server) {
        this.prevTime = server.method_30002().method_8532();
        this.method_80();
    }

    public void setDifficulty(double level, MinecraftServer server) {
        this.difficultyLevel = level;
        this.difficultyIndex = 0;
        this.prevTime = server.method_30002().method_8532();
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.method_80();
    }

    public void addDifficulty(double level, MinecraftServer server) {
        this.difficultyLevel += level;
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.method_80();
    }

    public double getDifficulty() {
        return this.difficultyLevel;
    }

    public long getPrevTime() {
        return this.prevTime;
    }

    public static double getDifficultyFromDist(class_3218 level, class_243 pos) {
        double dist = Config.CommonConfig.difficultyType == Config.DifficultyType.DISTANCESPAWN ? Math.sqrt(pos.method_1028((double)level.method_43126().method_10263() + 0.5, pos.method_10214(), (double)level.method_43126().method_10260() + 0.5)) : Math.sqrt(pos.method_1028((double)Config.CommonConfig.centerPos.getPos().x() + 0.5, pos.method_10214(), (double)Config.CommonConfig.centerPos.getPos().z() + 0.5));
        DifficultyExpressionConfig.Value value = (DifficultyExpressionConfig.Value)Config.CommonConfig.difficultyIncrease.get(dist, 0).getSecond();
        VariableMap map = new VariableMap();
        Config.apply(map, level.method_8409(), level.method_43126(), pos, 0.0);
        return value.expression().get(map);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void load(class_2487 tag) {
        this.difficultyLevel = tag.method_10574(IDENTIFIER);
        this.difficultyIndex = tag.method_10550("DifficultyIndex");
        this.prevTime = tag.method_10537("Time");
        this.paused = tag.method_10577("Paused");
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10549(IDENTIFIER, this.difficultyLevel);
        tag.method_10569("DifficultyIndex", this.difficultyIndex);
        tag.method_10544("Time", this.prevTime);
        tag.method_10556("Paused", this.paused);
        return tag;
    }
}

