/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.events;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.DifficultyFeatures;
import io.github.flemmli97.improvedmobs.api.datapack.EntityOverridesManager;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.common.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.common.entities.ai.BlockBreakGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.FlyRidingGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.ItemUseGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.LadderClimbGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.StealGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.WaterRidingGoal;
import io.github.flemmli97.improvedmobs.common.network.PacketHandler;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import io.github.flemmli97.improvedmobs.common.utils.BlockRestorationData;
import io.github.flemmli97.improvedmobs.common.utils.ContainerOpened;
import io.github.flemmli97.improvedmobs.common.utils.EntityFlags;
import io.github.flemmli97.improvedmobs.common.utils.Utils;
import io.github.flemmli97.improvedmobs.mixin.MobEntityMixin;
import io.github.flemmli97.improvedmobs.mixin.NearestTargetGoalMixin;
import io.github.flemmli97.improvedmobs.mixin.TargetGoalAccessor;
import io.github.flemmli97.improvedmobs.mixinhelper.EntitySpawnReason;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1410;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1680;
import net.minecraft.class_1686;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.minecraft.class_5354;
import net.minecraft.class_6025;
import net.minecraft.class_8103;
import net.minecraft.server.MinecraftServer;

public class EventCalls {
    public static void levelJoin(class_3222 player, MinecraftServer server) {
        CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
        CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createConfigPacket(), player);
    }

    public static void tick(class_3218 level) {
        BlockRestorationData.get(level).tick(level);
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        if (!Config.CommonConfig.enableDifficultyScaling) {
            DifficultyData.get(level.method_8503()).updateTime(level.method_8503());
            return;
        }
        if (!Config.CommonConfig.difficultyType.increaseDifficulty) {
            if (level.method_8510() % 20L == 0L) {
                CrossPlatformStuff.INSTANCE.sendDifficultyData(DifficultyData.get(level.method_8503()), level.method_8503());
                DifficultyData.get(level.method_8503()).updateTime(level.method_8503());
            }
            return;
        }
        boolean shouldIncrease = (Config.CommonConfig.ignorePlayers || !level.method_8503().method_3760().method_14571().isEmpty()) && level.method_8532() > (long)Config.CommonConfig.difficultyDelay;
        DifficultyData data = DifficultyData.get(level.method_8503());
        long timeDiff = Math.abs(level.method_8532() - data.getPrevTime());
        if (Config.CommonConfig.considerTimeskip) {
            if (timeDiff > 2400L) {
                long i = timeDiff / 2400L;
                if (timeDiff - i * 2400L > (i + 1L) * 2400L - timeDiff) {
                    ++i;
                }
                while (i > 0L) {
                    data.increaseDifficulty(shouldIncrease, level.method_8532(), level.method_8503());
                    --i;
                }
            }
        } else if (timeDiff > 2400L) {
            data.increaseDifficulty(shouldIncrease, level.method_8532(), level.method_8503());
        }
    }

    public static void onEntityLoad(class_1308 mob) {
        Predicate<class_1299<?>> targets;
        boolean hasVillagerTarget;
        boolean aggressive;
        boolean ignoreSight;
        if (mob.method_37908().field_9236 || mob instanceof RiddenSummonEntity) {
            return;
        }
        if (((EntitySpawnReason)mob).improvedMobs$getSpawnReason() == class_3730.field_16469 && Config.CommonConfig.ignoreSpawner) {
            return;
        }
        EntityFlags flags = EntityFlags.get((class_1297)mob);
        boolean mobGriefing = mob.method_37908().method_8450().method_8355(class_1928.field_19388);
        double difficulty = DifficultyData.getDifficulty(mob.method_37908(), (class_1309)mob);
        VariableMap map = Config.create((class_1309)mob, difficulty);
        if (flags.canBreakBlocks == EntityFlags.FlagType.UNDEFINED) {
            flags.canBreakBlocks = difficulty >= (double)Config.CommonConfig.difficultyBreak && (double)mob.method_59922().method_43057() < Config.CommonConfig.breakerChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.BLOCKBREAK) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        if (flags.canFly == EntityFlags.FlagType.UNDEFINED) {
            flags.canFly = (double)mob.method_59922().method_43057() < Config.CommonConfig.flyAIChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.FLYING) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        EventCalls.applyAttributesAndItems(mob, difficulty, map);
        if (!Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.USEITEM)) {
            mob.field_6201.method_6277(-1, (class_1352)new ItemUseGoal(mob));
        }
        if ((double)mob.method_59922().method_43057() < Config.CommonConfig.guardianAIChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.GUARDIAN)) {
            mob.field_6201.method_6277(6, (class_1352)new WaterRidingGoal(mob));
        }
        if (flags.canFly == EntityFlags.FlagType.TRUE) {
            mob.field_6201.method_6277(6, (class_1352)new FlyRidingGoal(mob));
            if (!(((MobEntityMixin)mob).getTrueNavigator() instanceof class_1407) && !(mob instanceof class_1621)) {
                mob.field_6201.method_6277(6, (class_1352)new FlyRidingGoal(mob));
            }
        }
        if (!Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.LADDER) && !(mob.method_5942() instanceof class_1410)) {
            EntityFlags.get((class_1297)mob).ladderClimber = true;
            mob.field_6201.method_6277(4, (class_1352)new LadderClimbGoal(mob));
        }
        boolean villager = !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.TARGETVILLAGER);
        boolean bl = ignoreSight = (double)mob.method_59922().method_43057() < Config.CommonConfig.ignoreSightChance.get(map);
        if (mob instanceof class_5354 && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.NEUTRALAGGRO)) {
            boolean bl2 = aggressive = (double)mob.method_59922().method_43057() < Config.CommonConfig.neutralAggressiv.get(map);
            if (aggressive) {
                mob.field_6185.method_6277(1, EventCalls.setNoLoS(mob, class_1657.class, ignoreSight, null));
            }
        } else {
            aggressive = true;
        }
        if (villager && aggressive && !(hasVillagerTarget = mob.field_6185.method_35115().stream().anyMatch(g -> {
            NearestTargetGoalMixin target;
            class_1352 patt0$temp;
            return g != null && (patt0$temp = g.method_19058()) instanceof NearestTargetGoalMixin && (target = (NearestTargetGoalMixin)patt0$temp).targetTypeClss() == class_3988.class;
        }))) {
            mob.field_6185.method_6277(3, EventCalls.setNoLoS(mob, class_3988.class, ignoreSight, null));
        }
        if ((targets = Config.CommonConfig.autoTargets.get(mob.method_5864())) != null) {
            mob.field_6185.method_6277(3, EventCalls.setNoLoS(mob, class_1309.class, ignoreSight, l -> targets.test(l.method_5864())));
        }
        if (mob instanceof class_1314) {
            class_1314 pathfinderMob = (class_1314)mob;
            if (difficulty >= (double)Config.CommonConfig.difficultySteal && mobGriefing && (double)mob.method_59922().method_43057() < Config.CommonConfig.stealerChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.STEAL)) {
                pathfinderMob.field_6201.method_6277(5, (class_1352)new StealGoal(pathfinderMob));
            }
        }
        if (flags.canBreakBlocks == EntityFlags.FlagType.TRUE) {
            mob.field_6185.method_35115().forEach(g -> {
                if (g != null && g.method_19058() instanceof class_1400 && mob.method_59922().method_43057() < Config.CommonConfig.breakerSightIgnore) {
                    ((TargetGoalAccessor)g.method_19058()).setShouldCheckSight(false);
                    ((NearestTargetGoalMixin)g.method_19058()).getTargetEntitySelector().method_36627();
                }
            });
            if (mobGriefing) {
                mob.field_6201.method_6277(1, (class_1352)new BlockBreakGoal(mob));
                if (mob.method_6079().method_7960()) {
                    class_1799 stack = Config.CommonConfig.getRandomBreakingItem(mob.method_59922());
                    mob.method_5946(class_1304.field_6171, (float)Config.CommonConfig.dropChance.get(map));
                    mob.method_5673(class_1304.field_6171, stack);
                }
            }
        }
    }

    private static <T extends class_1309> class_1400<T> setNoLoS(class_1308 e, Class<T> clss, boolean ignoreSight, Predicate<class_1309> pred) {
        class_1400 goal = pred == null ? new class_1400(e, clss, !ignoreSight) : new class_1400(e, clss, 10, !ignoreSight, false, pred);
        if (ignoreSight) {
            ((NearestTargetGoalMixin)goal).getTargetEntitySelector().method_36627();
        }
        return goal;
    }

    private static void applyAttributesAndItems(class_1308 living, double difficulty, VariableMap map) {
        EntityFlags flags = EntityFlags.get((class_1297)living);
        if (!flags.modifyArmor) {
            if (!Config.CommonConfig.entityBlacklist.isDisabledFor(living, DifficultyFeatures.ARMOR)) {
                Utils.equipArmor(living, difficulty, map);
            }
            flags.modifyArmor = true;
        }
        if (!flags.modifyHeldItems) {
            if (!Config.CommonConfig.entityBlacklist.isDisabledFor(living, DifficultyFeatures.HELDITEMS)) {
                Utils.equipHeld(living, difficulty, map);
            }
            flags.modifyHeldItems = true;
        }
        if (!flags.enchantGear) {
            Utils.enchantGear(living, difficulty, map);
            flags.enchantGear = true;
        }
        if (!flags.modifyAttributes) {
            if (!Config.CommonConfig.entityBlacklist.isDisabledFor(living, DifficultyFeatures.ATTRIBUTES)) {
                EntityOverridesManager.getInstance().applyAttributesTo((class_1309)living, map);
            }
            flags.modifyAttributes = true;
        }
    }

    public static float hurtEvent(class_1309 entity, class_1282 source, float dmg) {
        if (source.method_48789(class_8103.field_42247) && source.method_5529() instanceof class_1588) {
            return (float)((double)dmg * EntityFlags.get(source.method_5529()).getAttribute(EntityFlags.ServerSideAttributes.PROJECTILE_DAMAGE_MULTIPLIER));
        }
        if (source.method_48789(class_8103.field_42249) && source.method_5529() instanceof class_1588) {
            return (float)((double)dmg * EntityFlags.get(source.method_5529()).getAttribute(EntityFlags.ServerSideAttributes.EXPLOSION_DAMAGE_MULTIPLIER));
        }
        if (entity instanceof class_1588 && source.method_48789(class_8103.field_42248)) {
            return (float)((double)dmg * (1.0 - EntityFlags.get((class_1297)entity).getAttribute(EntityFlags.ServerSideAttributes.MAGIC_RESISTANCE)));
        }
        return dmg;
    }

    public static boolean onAttackEvent(class_1309 target, class_1282 damagesource) {
        if (!target.method_37908().field_9236) {
            class_1309 attacker;
            if (!Config.CommonConfig.friendlyFire && target instanceof class_1321) {
                class_1321 pet = (class_1321)target;
                if (damagesource.method_5529() != null && damagesource.method_5529() == pet.method_35057() && !damagesource.method_5529().method_5715()) {
                    return true;
                }
            }
            class_1297 source = damagesource.method_5529();
            if (target instanceof class_1657) {
                class_1297 direct = damagesource.method_5526();
                if (direct instanceof class_1680) {
                    EntityFlags flag = EntityFlags.get(direct);
                    if (flag.isThrownEntity) {
                        flag.isThrownEntity = false;
                        target.method_5643(damagesource, 0.001f);
                    }
                }
            } else if (source instanceof class_1309 && CrossPlatformStuff.INSTANCE.canDisableShield((attacker = (class_1309)source).method_6047(), target.method_6030(), target, attacker)) {
                EventCalls.triggerDisableShield(target);
            }
        }
        return false;
    }

    private static void triggerDisableShield(class_1309 target) {
        EntityFlags.get((class_1297)target).disableShield();
        target.method_6021();
        target.method_37908().method_8421((class_1297)target, (byte)30);
    }

    public static void openTile(class_1657 player, class_2338 pos) {
        class_2586 blockEntity;
        if (!player.method_37908().field_9236 && !player.method_5715() && (blockEntity = player.method_37908().method_8321(pos)) != null) {
            ((ContainerOpened)ImprovedMobsAttachments.HAS_BEEN_OPENED.get().get((Object)blockEntity)).setOpened(blockEntity);
        }
    }

    public static boolean equipPet(class_1657 player, class_1268 hand, class_1297 target) {
        class_1799 heldItem;
        class_1792 class_17922;
        class_6025 pet;
        class_1308 mob;
        if (hand == class_1268.field_5808 && target instanceof class_1308 && ((mob = (class_1308)target) instanceof class_6025 || mob.method_5864().method_20210(ImprovedMobs.ARMOR_EQUIPPABLE)) && !target.method_37908().field_9236 && player.method_5715() && !Utils.isInList(target, Config.CommonConfig.petArmorBlackList, Config.CommonConfig.petWhiteList, Utils.ENTITY_ID) && (!(mob instanceof class_6025) || player == (pet = (class_6025)mob).method_35057()) && (class_17922 = (heldItem = player.method_6047()).method_7909()) instanceof class_1738) {
            class_1738 armor = (class_1738)class_17922;
            class_1304 type = armor.method_7685();
            switch (type) {
                case field_6169: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6169);
                    break;
                }
                case field_6174: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6174);
                    break;
                }
                case field_6172: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6172);
                    break;
                }
                case field_6166: {
                    EventCalls.equipPetItem(player, mob, heldItem, class_1304.field_6166);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static void equipPetItem(class_1657 player, class_1308 living, class_1799 stack, class_1304 slot) {
        class_1799 current = living.method_6118(slot);
        if (!current.method_7960() && !player.method_7337()) {
            class_1542 entityitem = new class_1542(living.method_37908(), living.method_23317(), living.method_23318(), living.method_23321(), current);
            entityitem.method_6975();
            living.method_37908().method_8649((class_1297)entityitem);
        }
        class_1799 copy = stack.method_7972();
        copy.method_7939(1);
        living.method_5673(slot, copy);
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
    }

    public static boolean projectileImpact(class_1676 projectile, class_239 hitResult) {
        class_3966 res;
        class_1297 thrower;
        return EntityFlags.get((class_1297)projectile).isThrownEntity && (thrower = projectile.method_24921()) instanceof class_1308 && !(projectile instanceof class_1686) && hitResult.method_17783() == class_239.class_240.field_1331 && !(res = (class_3966)hitResult).method_17782().equals((Object)((class_1308)thrower).method_5968());
    }

    public static void explosion(class_1927 explosion, class_1297 source, List<class_1297> affectedEntities) {
        if (source instanceof class_1541 && EntityFlags.get((class_1297)source).isThrownEntity) {
            class_1309 igniter;
            if (!Config.CommonConfig.tntBlockDestruction) {
                explosion.method_8346().clear();
            }
            if ((igniter = explosion.method_8347()) instanceof class_1308) {
                affectedEntities.removeIf(e -> !e.equals((Object)((class_1308)igniter).method_5968()));
            }
        }
    }

    public static void onTagReloaded() {
        Config.CommonConfig.breakableBlocks.tagReloaded();
        Config.CommonConfig.autoTargets.tagReloaded();
        Config.CommonConfig.entityBlacklist.tagReloaded();
    }
}

