/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.utils;

import io.github.flemmli97.improvedmobs.common.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.mixinhelper.EntityData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class EntityFlags {
    public static final String TAG_ID = "IMFlags";
    public static final String SERVER_ENTITY_TAG_ID = "ServerSideEntityID";
    public boolean ladderClimber;
    public boolean modifyArmor;
    public boolean modifyHeldItems;
    public boolean modifyAttributes;
    public boolean enchantGear;
    public boolean isThrownEntity;
    public FlagType canBreakBlocks = FlagType.UNDEFINED;
    public FlagType canFly = FlagType.UNDEFINED;
    private int shieldCooldown;
    private final Map<ServerSideAttributes, Double> attributes = new HashMap<ServerSideAttributes, Double>();
    public class_2960 serverSideEntityID;

    public static EntityFlags get(class_1297 entity) {
        class_1297 passenger;
        if (entity instanceof RiddenSummonEntity && (passenger = entity.method_31483()) != null) {
            return EntityFlags.get(passenger);
        }
        return ((EntityData)entity).improvedMobs$getFlags();
    }

    public void disableShield() {
        this.shieldCooldown = 120;
    }

    public boolean isShieldDisabled() {
        return --this.shieldCooldown > 0;
    }

    public double getAttribute(ServerSideAttributes attribute) {
        return this.attributes.getOrDefault((Object)attribute, attribute.defaultValue);
    }

    public void setAttribute(ServerSideAttributes attribute, double value) {
        this.attributes.put(attribute, value);
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10569("CanBreakBlocks", this.canBreakBlocks.ordinal());
        tag.method_10569("CanFly", this.canFly.ordinal());
        tag.method_10556("ModifiedArmor", this.modifyArmor);
        tag.method_10556("ModifiedHeld", this.modifyHeldItems);
        tag.method_10556("ModifiedAttributes", this.modifyAttributes);
        tag.method_10556("GearEnchanted", this.enchantGear);
        tag.method_10556("IsThrown", this.isThrownEntity);
        class_2487 attributes = new class_2487();
        this.attributes.forEach((att, val) -> attributes.method_10549(att.name(), val.doubleValue()));
        tag.method_10566("Attributes", (class_2520)attributes);
        return tag;
    }

    public void load(class_2487 nbt) {
        this.canBreakBlocks = FlagType.values()[nbt.method_10550("CanBreakBlocks")];
        this.canFly = FlagType.values()[nbt.method_10550("CanFly")];
        this.modifyArmor = nbt.method_10577("ModifiedArmor");
        this.modifyHeldItems = nbt.method_10577("ModifiedHeld");
        this.modifyAttributes = nbt.method_10577("ModifiedAttributes");
        this.enchantGear = nbt.method_10577("GearEnchanted");
        this.isThrownEntity = nbt.method_10577("IsThrown");
        this.attributes.clear();
        class_2487 attributes = nbt.method_10562("Attributes");
        attributes.method_10541().forEach(key -> this.attributes.put(ServerSideAttributes.valueOf(key), attributes.method_10574(key)));
        if (nbt.method_10545(SERVER_ENTITY_TAG_ID)) {
            this.serverSideEntityID = class_2960.method_60654((String)nbt.method_10558(SERVER_ENTITY_TAG_ID));
        }
    }

    public static enum FlagType {
        UNDEFINED,
        TRUE,
        FALSE;

    }

    public static enum ServerSideAttributes {
        MAGIC_RESISTANCE(0.0),
        PROJECTILE_DAMAGE_MULTIPLIER(1.0),
        EXPLOSION_DAMAGE_MULTIPLIER(1.0);

        public final double defaultValue;

        private ServerSideAttributes(double defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

