/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.utils;

import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.utils.CustomBlockCollision;
import io.github.flemmli97.improvedmobs.common.utils.Utils;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_3726;
import net.minecraft.class_9;

public class PathFindingUtils {
    public static class_9 handleBreakableNode(class_1308 mob, class_1922 getter, int x, int y, int z, class_2350 dir, class_9 origin, Function<class_238, Boolean> collision, Function<class_238, Boolean> collisionDefault, Function<class_2338, class_9> nodeGetter) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        class_238 aabb = PathFindingUtils.createAABBForPos(getter, x, y, z, (double)mob.method_17681() / 2.0, mob.method_17682());
        boolean defaultCollides = collisionDefault.apply(aabb.method_1012((double)(-dir.method_10148()), 0.0, (double)(-dir.method_10165())));
        if (!defaultCollides) {
            return null;
        }
        boolean breakableCollides = collision.apply(aabb.method_1012((double)(-dir.method_10148()), 0.0, (double)(-dir.method_10165())));
        if (!breakableCollides) {
            if (origin.field_39 != y) {
                pos.method_10103(x, origin.field_39, z);
            }
            return nodeGetter.apply((class_2338)pos);
        }
        return null;
    }

    public static boolean noCollision(class_1941 level, class_1309 entity, class_238 aABB, boolean breakable, boolean ladder) {
        Iterable shapes = () -> new CustomBlockCollision(level, entity, aABB, breakable, ladder);
        for (class_265 voxelShape : shapes) {
            if (voxelShape.method_1110()) continue;
            return false;
        }
        if (entity != null) {
            class_2784 worldBorder = level.method_8621();
            class_265 voxelShape2 = worldBorder.method_39459((class_1297)entity, aABB) ? worldBorder.method_17903() : null;
            return voxelShape2 == null || !class_259.method_1074((class_265)voxelShape2, (class_265)class_259.method_1078((class_238)aABB), (class_247)class_247.field_16896);
        }
        return true;
    }

    public static class_238 createAABBForPos(int x, int y, int z, double widthHalf, double height) {
        return new class_238((double)x - widthHalf + 0.5, (double)y, (double)z - widthHalf + 0.5, (double)x + widthHalf + 0.5, (double)y + height, (double)z + widthHalf + 0.5);
    }

    public static class_238 createAABBForPos(class_1922 getter, int x, int y, int z, double widthHalf, double height) {
        double floor1 = class_14.method_60((class_1922)getter, (class_2338)new class_2338(x, y + 1, z));
        return new class_238((double)x - widthHalf + 0.5, floor1 + 0.001, (double)z - widthHalf + 0.5, (double)x + widthHalf + 0.5, height + floor1, (double)z + widthHalf + 0.5);
    }

    public static int createLadderNodeFor(int nodeID, class_9[] nodes, class_9 origin, Function<class_2338, class_9> nodeGetter, class_1308 mob, Long2BooleanMap cache) {
        class_9 node;
        class_2338.class_2339 pos = new class_2338.class_2339(origin.field_40, origin.field_39 + 1, origin.field_38);
        if (cache.computeIfAbsent(pos.method_10063(), l -> {
            class_2680 state = mob.method_37908().method_8320((class_2338)pos);
            return CrossPlatformStuff.INSTANCE.isClimbable(state, (class_1309)mob, (class_2338)pos);
        }) && (node = nodeGetter.apply((class_2338)pos)) != null && !node.field_42 && nodeID + 1 < nodes.length) {
            nodes[nodeID++] = node;
        }
        pos.method_10103(pos.method_10263(), pos.method_10264() - 1, pos.method_10260());
        if (cache.computeIfAbsent(pos.method_10063(), l -> {
            class_2680 state = mob.method_37908().method_8320((class_2338)pos);
            return CrossPlatformStuff.INSTANCE.isClimbable(state, (class_1309)mob, (class_2338)pos);
        }) && (node = nodeGetter.apply((class_2338)pos)) != null && !node.field_42 && nodeID + 1 < nodes.length) {
            nodes[nodeID++] = node;
        }
        return nodeID;
    }

    public static int createBreakableNodeBelow(int nodeID, class_9[] nodes, class_9 origin, Function<class_2338, class_9> nodeGetter, class_1308 mob, Long2BooleanMap cache) {
        class_9 node;
        class_2338 pos = new class_2338(origin.field_40, origin.field_39 - 1, origin.field_38);
        if (cache.computeIfAbsent(pos.method_10063(), l -> {
            class_2680 state = mob.method_37908().method_8320(pos);
            return PathFindingUtils.canBreak(state, pos, mob);
        }) && (node = nodeGetter.apply(pos)) != null && !node.field_42 && nodeID + 1 < nodes.length) {
            nodes[nodeID++] = node;
        }
        return nodeID;
    }

    public static boolean canBreak(class_2680 state, class_2338 pos, class_1308 entity) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (class_1922)entity.method_37908(), (class_1297)entity, class_3726.method_16195((class_1297)entity)) && (Utils.canHarvest(state, entity.method_6047()) || Utils.canHarvest(state, entity.method_6079()));
    }
}

