/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.utils;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.config.equipment.EquipmentList;
import io.github.flemmli97.improvedmobs.common.config.values.StepExpressionConfig;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9334;

public class Utils {
    public static final Function<class_1297, class_2960> ENTITY_ID = e -> class_7923.field_41177.method_10221((Object)e.method_5864());
    public static final class_2960 ATTRIBUTE_ID = ImprovedMobs.modRes("attribute_modifiers");

    public static <T> boolean isInList(T entry, List<? extends String> list, boolean reverse, Function<T, class_2960> mapper) {
        if (reverse) {
            return !Utils.isInList(entry, list, false, mapper);
        }
        class_2960 res = mapper.apply(entry);
        return list.contains(res.method_12832()) || list.contains(res.toString());
    }

    public static boolean canHarvest(class_2680 block, class_1799 item) {
        if (Config.CommonConfig.ignoreHarvestLevel) {
            return true;
        }
        return item.method_7951(block) || !block.method_29291();
    }

    public static void equipArmor(class_1308 living, double difficulty, VariableMap map) {
        if ((double)living.method_59922().method_43057() < Config.CommonConfig.equipmentChance.get(map)) {
            for (class_1304 slot : class_1304.values()) {
                boolean shouldAdd;
                if (slot.method_5925() == class_1304.class_1305.field_6177) continue;
                boolean bl = shouldAdd = slot == class_1304.field_6169 || (double)living.method_59922().method_43057() < Config.CommonConfig.additionalEquipmentChance.get(map);
                if (!shouldAdd || !living.method_6118(slot).method_7960()) continue;
                class_1799 equip = EquipmentList.getEquipment(living, slot, difficulty);
                if ((double)living.method_59922().method_43057() < Config.CommonConfig.randomTrimChance.get(map)) {
                    class_5455.class_6890 registryAccess = living.method_5682().method_30611();
                    Optional trim = registryAccess.method_33310(class_7924.field_42083).flatMap(r -> r.method_10240(living.method_59922()));
                    Optional pattern = living.method_5682().method_30611().method_33310(class_7924.field_42082).flatMap(r -> r.method_10240(living.method_59922()));
                    if (trim.isPresent() && pattern.isPresent()) {
                        equip.method_57379(class_9334.field_49607, (Object)new class_8053((class_6880)trim.get(), (class_6880)pattern.get()));
                    }
                }
                if (equip.method_7960()) continue;
                living.method_5946(slot, (float)Config.CommonConfig.dropChance.get(map));
                living.method_5673(slot, equip);
            }
        }
    }

    public static void equipHeld(class_1308 living, double difficulty, VariableMap map) {
        class_1799 stack;
        if ((double)living.method_59922().method_43057() < Config.CommonConfig.mainHandChance.get(map) && living.method_6047().method_7960()) {
            stack = EquipmentList.getEquipment(living, class_1304.field_6173, difficulty);
            living.method_5946(class_1304.field_6173, (float)Config.CommonConfig.dropChance.get(map));
            living.method_5673(class_1304.field_6173, stack);
        }
        if (living instanceof class_5418) {
            return;
        }
        if ((double)living.method_59922().method_43057() < Config.CommonConfig.offHandChance.get(map) && living.method_6079().method_7960()) {
            stack = EquipmentList.getEquipment(living, class_1304.field_6171, difficulty);
            living.method_5946(class_1304.field_6171, (float)Config.CommonConfig.dropChance.get(map));
            living.method_5673(class_1304.field_6171, stack);
        }
    }

    public static void enchantGear(class_1308 living, double difficulty, VariableMap map) {
        StepExpressionConfig.Value val = Config.CommonConfig.enchantCalc.get(difficulty);
        int level = (int)val.expression().get(map);
        if (level == 0) {
            return;
        }
        for (class_1304 entityequipmentslot : class_1304.values()) {
            class_1799 itemstack = living.method_6118(entityequipmentslot);
            if (itemstack.method_7942() || itemstack.method_7960() || !((double)living.method_59922().method_43057() < Config.CommonConfig.enchantChance.get(map))) continue;
            class_5455 registryAccess = living.method_56673();
            class_1890.method_8233((class_5819)living.method_59922(), (class_1799)itemstack, (int)level, registryAccess.method_30530(class_7924.field_41265).method_40270().filter(r -> Config.CommonConfig.enchantWhitelist == Config.CommonConfig.enchantBlacklist.contains(r.method_40237().method_29177().toString())).map(r -> r));
        }
    }

    public static float getBlockStrength(class_1308 entityLiving, class_2680 state, class_1937 level, class_2338 pos) {
        float hardness = level.method_8320(pos).method_26214((class_1922)level, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        class_1799 main = entityLiving.method_6047();
        class_1799 off = entityLiving.method_6079();
        if (Utils.canHarvest(state, main)) {
            float offSpeed;
            float speed = Utils.getBreakSpeed(entityLiving, main, state);
            if (Utils.canHarvest(state, off) && (offSpeed = Utils.getBreakSpeed(entityLiving, off, state)) > speed) {
                speed = offSpeed;
            }
            return speed / hardness / 30.0f;
        }
        if (Utils.canHarvest(state, off)) {
            return Utils.getBreakSpeed(entityLiving, off, state) / hardness / 30.0f;
        }
        return Utils.getBreakSpeed(entityLiving, main, state) / hardness / 100.0f;
    }

    public static float getBreakSpeed(class_1308 entity, class_1799 stack, class_2680 state) {
        float f = stack.method_7924(state);
        if (f > 1.0f && entity.method_6127().method_45331(class_5134.field_51581)) {
            f += (float)entity.method_45325(class_5134.field_51581);
        }
        if (class_1292.method_5576((class_1309)entity)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)entity) + 1) * 0.2f;
        }
        if (entity.method_6059(class_1294.field_5901)) {
            switch (entity.method_6112(class_1294.field_5901).method_5578()) {
                case 0: {
                    f *= 0.3f;
                    break;
                }
                case 1: {
                    f *= 0.09f;
                    break;
                }
                case 2: {
                    f *= 0.0027f;
                    break;
                }
                default: {
                    f *= 8.1E-4f;
                }
            }
        }
        if (entity.method_5777(class_3486.field_15517) && entity.method_5996(class_5134.field_51576) != null) {
            f *= (float)entity.method_5996(class_5134.field_51576).method_6194();
        }
        if (!entity.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }
}

