/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.item.impl;

import io.github.flemmli97.improvedmobs.api.item.ItemUseHandler;
import io.github.flemmli97.improvedmobs.api.item.MoveHandler;
import io.github.flemmli97.improvedmobs.api.item.impl.move.KeepDistanceMover;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class CrossbowHandler
implements ItemUseHandler {
    @Override
    public void start(LivingEntity entity, LivingEntity target, InteractionHand hand) {
        entity.startUsingItem(hand);
    }

    @Override
    public void onPrepare(LivingEntity entity, LivingEntity target, InteractionHand hand) {
        ItemStack itemstack;
        int i = entity.getTicksUsingItem();
        if (i >= CrossbowItem.getChargeDuration((ItemStack)(itemstack = entity.getUseItem()), (LivingEntity)entity)) {
            entity.releaseUsingItem();
        }
    }

    @Override
    public void use(LivingEntity entity, LivingEntity target, InteractionHand hand) {
        ItemStack stack = entity.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof CrossbowItem) {
            CrossbowItem crossbow = (CrossbowItem)item;
            ChargedProjectiles projectile = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            float vel = projectile.contains(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
            crossbow.performShooting(entity.level(), entity, hand, stack, vel, (float)(14 - entity.level().getDifficulty().getId() * 4), target);
        }
    }

    @Override
    public ItemUseHandler.PreferredHand preferredHand() {
        return ItemUseHandler.PreferredHand.ANY;
    }

    @Override
    public int cooldown(LivingEntity entity) {
        return 30;
    }

    @Override
    public int attackDelay(LivingEntity entity, ItemStack stack) {
        return CrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)entity) + 20 + entity.getRandom().nextInt(20);
    }

    @Override
    public boolean matches(Item item) {
        return item instanceof CrossbowItem;
    }

    @Override
    public Function<Mob, MoveHandler> movementType() {
        return mob -> new KeepDistanceMover((Mob)mob, 8.0);
    }
}

