/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.config.values;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class TargetMapConfig {
    private final List<String> config = new ArrayList<String>();
    private boolean initialized;
    private final Map<EntityType<?>, Predicate<EntityType<?>>> map = new HashMap();

    @Nullable
    public Predicate<EntityType<?>> get(EntityType<?> type) {
        this.initialize();
        return this.map.get(type);
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap<EntityType, PredicateBuilder> direct = new HashMap<EntityType, PredicateBuilder>();
        HashMap<HolderSet, PredicateBuilder> tags = new HashMap<HolderSet, PredicateBuilder>();
        for (String value : this.config) {
            Consumer<Either> cons;
            TagKey tag;
            String[] sub = value.replace(" ", "").split("-");
            if (sub.length < 2) continue;
            String source = sub[0];
            if (source.startsWith("#")) {
                tag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)source.substring(1)));
                cons = either -> BuiltInRegistries.ENTITY_TYPE.getTag(tag).ifPresent(named -> either.ifLeft(t -> tags.computeIfAbsent((HolderSet)named, key -> new PredicateBuilder()).appendTag((TagKey<EntityType<?>>)t)).ifRight(t -> tags.computeIfAbsent((HolderSet)named, key -> new PredicateBuilder()).appendType((EntityType<?>)t)));
            } else {
                Optional type2 = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)source));
                if (type2.isEmpty()) continue;
                cons = either -> either.ifLeft(t -> direct.computeIfAbsent((EntityType)type2.get(), key -> new PredicateBuilder()).appendTag((TagKey<EntityType<?>>)t)).ifRight(t -> direct.computeIfAbsent((EntityType)type2.get(), key -> new PredicateBuilder()).appendType((EntityType<?>)t));
            }
            if (sub[1].startsWith("#")) {
                tag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)sub[1].substring(1)));
                if (!BuiltInRegistries.ENTITY_TYPE.getTag(tag).isPresent()) continue;
                cons.accept(Either.left((Object)tag));
                continue;
            }
            EntityType target = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)sub[1])).orElse(null);
            if (target == null) {
                ImprovedMobs.LOGGER.error("Entity {} does not exist/is not registered", (Object)sub[1]);
                continue;
            }
            cons.accept(Either.right((Object)target));
        }
        direct.forEach((type, pred) -> this.map.put((EntityType<?>)type, pred.build()));
        tags.forEach((set, pred) -> set.forEach(h -> this.map.put((EntityType)h.value(), pred.build())));
    }

    public void tagReloaded() {
        this.map.clear();
        this.initialized = false;
        this.initialize();
    }

    public void read(List<String> config) {
        this.map.clear();
        this.config.clear();
        this.config.addAll(config);
        this.initialized = false;
    }

    public List<String> write() {
        return List.copyOf(this.config);
    }

    public static String[] use() {
        return new String[]{"List for of pairs containing which mobs auto target others.", "Syntax is <source-target> where", "  source: is the mob that should target something. This can be either an entity or a tag", "  target: the mob source should target. This can be either an entity or a tag", "Examples: ", "minecraft:zombie-minecraft:skeleton makes all zombies target skeletons", "minecraft:zombie-#minecraft:raiders makes all zombies target raid entities"};
    }

    private static class PredicateBuilder {
        private final List<EntityType<?>> direct = new ArrayList();
        private final List<TagKey<EntityType<?>>> tags = new ArrayList();

        private PredicateBuilder() {
        }

        public void appendType(EntityType<?> type) {
            this.direct.add(type);
        }

        public void appendTag(TagKey<EntityType<?>> tag) {
            this.tags.add(tag);
        }

        public Predicate<EntityType<?>> build() {
            ImmutableSet direct = ImmutableSet.copyOf(this.direct);
            ImmutableList tags = ImmutableList.copyOf(this.tags);
            return arg_0 -> PredicateBuilder.lambda$build$0((Set)direct, (List)tags, arg_0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static /* synthetic */ boolean lambda$build$0(Set direct, List tags, EntityType type) {
            if (direct.contains(type)) return true;
            if (!tags.stream().anyMatch(arg_0 -> ((EntityType)type).is(arg_0))) return false;
            return true;
        }
    }
}

