/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.entities.ai;

import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyFetcher;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.utils.BlockRestorationData;
import io.github.flemmli97.improvedmobs.common.utils.Utils;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BlockBreakGoal
extends Goal {
    protected final Mob living;
    private LivingEntity target;
    private BlockPos markedLoc;
    private BlockPos entityPos;
    private int digTimer;
    private int cooldown = Config.CommonConfig.breakerInitCooldown;
    private final List<BlockPos> breakAOE = new ArrayList<BlockPos>();
    private int breakIndex;
    private final int digHeight;
    private final VariableMap variables = new VariableMap();

    public BlockBreakGoal(Mob living) {
        this.living = living;
        int digWidth = living.getBbWidth() < 1.0f ? 0 : Mth.ceil((float)living.getBbWidth());
        for (int i = this.digHeight = (int)living.getBbHeight() + 1; i >= 0; --i) {
            this.breakAOE.add(new BlockPos(0, i, 0));
        }
        for (int z = digWidth + 1; z >= -digWidth; --z) {
            for (int y = this.digHeight; y >= 0; --y) {
                for (int x = 0; x <= digWidth; ++x) {
                    if (z == 0) continue;
                    this.breakAOE.add(new BlockPos(x, y, z));
                    if (x == 0) continue;
                    this.breakAOE.add(new BlockPos(-x, y, z));
                }
            }
        }
    }

    public boolean canUse() {
        this.target = this.living.getTarget();
        if (this.entityPos == null) {
            this.entityPos = this.living.blockPosition();
            this.cooldown = Config.CommonConfig.breakerCooldown;
        }
        if (--this.cooldown <= 0) {
            if (!this.entityPos.equals((Object)this.living.blockPosition())) {
                this.entityPos = null;
                this.cooldown = Config.CommonConfig.breakerCooldown;
                return false;
            }
            if (this.target != null && (double)this.living.distanceTo((Entity)this.target) > 1.0) {
                BlockPos blockPos = this.getDiggingLocation();
                if (blockPos == null) {
                    return false;
                }
                this.cooldown = Config.CommonConfig.breakerCooldown;
                this.markedLoc = blockPos;
                this.entityPos = this.living.blockPosition();
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.living.isAlive() && this.markedLoc != null && this.nearSameSpace(this.entityPos, this.living.blockPosition()) && (double)this.living.distanceTo((Entity)this.target) > 1.0;
    }

    private boolean nearSameSpace(BlockPos pos1, BlockPos pos2) {
        return pos1 != null && pos2 != null && pos1.getX() == pos2.getX() && pos1.getZ() == pos2.getZ() && Math.abs(pos1.getY() - pos2.getY()) <= 1;
    }

    public void stop() {
        this.breakIndex = 0;
        if (this.markedLoc != null) {
            this.living.level().destroyBlockProgress(this.living.getId(), this.markedLoc, -1);
        }
        this.markedLoc = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.markedLoc == null || this.living.level().getBlockState(this.markedLoc).getCollisionShape((BlockGetter)this.living.level(), this.markedLoc).isEmpty()) {
            this.digTimer = 0;
            return;
        }
        BlockState state = this.living.level().getBlockState(this.markedLoc);
        float str = Utils.getBlockStrength(this.living, state, this.living.level(), this.markedLoc);
        float f = str = str == Float.POSITIVE_INFINITY ? 1.0f : str / (1.0f + str * 6.0f) * ((float)this.digTimer * this.breakSpeedMod() + 1.0f);
        if (str >= 1.0f) {
            boolean canHarvest;
            Level level;
            this.digTimer = 0;
            this.cooldown = (int)((double)this.cooldown * 0.5);
            ItemStack item = this.living.getMainHandItem();
            ItemStack itemOff = this.living.getOffhandItem();
            if (Config.CommonConfig.restoreDelay > 0 && (level = this.living.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                canHarvest = false;
                BlockRestorationData.get(serverLevel).restore(serverLevel, serverLevel.getBlockState(this.markedLoc), this.markedLoc, (Entity)this.living);
            } else {
                canHarvest = Utils.canHarvest(state, item) || Utils.canHarvest(state, itemOff);
            }
            this.living.level().destroyBlock(this.markedLoc, canHarvest);
            this.living.level().destroyBlockProgress(this.living.getId(), this.markedLoc, -1);
            this.markedLoc = null;
            if (!this.aboveTarget()) {
                this.living.setSpeed(0.0f);
                this.living.getNavigation().stop();
                this.living.getNavigation().moveTo(this.living.getNavigation().createPath((Entity)this.target, 0), 1.0);
            } else {
                this.living.getNavigation().stop();
            }
        } else {
            ++this.digTimer;
            if (this.digTimer % 5 == 0) {
                SoundType sound = CrossPlatformStuff.INSTANCE.blockSound(state, (LivingEntity)this.living, this.markedLoc);
                this.living.level().playSeededSound(null, (double)this.markedLoc.getX() + 0.5, (double)this.markedLoc.getY() + 0.5, (double)this.markedLoc.getZ() + 0.5, (Holder)(Config.CommonConfig.useBlockBreakSound ? BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)sound.getBreakSound()) : SoundEvents.NOTE_BLOCK_BASS), SoundSource.BLOCKS, 2.0f, 0.5f, this.living.level().getRandom().nextLong());
                this.living.swing(InteractionHand.MAIN_HAND);
                this.living.getLookControl().setLookAt((double)this.markedLoc.getX(), (double)this.markedLoc.getY(), (double)this.markedLoc.getZ(), 0.0f, 0.0f);
                this.living.level().destroyBlockProgress(this.living.getId(), this.markedLoc, (int)(str * 10.0f) - 1);
            }
        }
    }

    private float breakSpeedMod() {
        return (float)Config.CommonConfig.breakSpeed.get(Config.apply(this.variables, (LivingEntity)this.living, DifficultyFetcher.getDifficulty((ServerLevel)this.living.level(), this.living.position())));
    }

    public BlockPos getDiggingLocation() {
        BlockState state;
        ItemStack item = this.living.getMainHandItem();
        ItemStack itemOff = this.living.getOffhandItem();
        BlockPos pos = this.living.blockPosition();
        if (this.living.getTarget() != null) {
            Vec3 target = this.living.getTarget().position();
            if (this.aboveTarget() && Math.abs(target.x - (double)pos.getX()) <= 1.0 && Math.abs(target.z - (double)pos.getZ()) <= 1.0) {
                pos = this.living.blockPosition().below();
                state = this.living.level().getBlockState(pos);
                if (this.canBreak((LivingEntity)this.living, state, pos, item, itemOff)) {
                    this.breakIndex = 0;
                    return pos;
                }
            }
        }
        Rotation rot = BlockBreakGoal.getDigDirection(this.living);
        BlockPos offset = this.breakAOE.get(this.breakIndex);
        offset = new BlockPos(offset.getX(), this.aboveTarget() ? -(this.digHeight - offset.getY()) : offset.getY(), offset.getZ());
        pos = pos.offset((Vec3i)offset.rotate(rot));
        state = this.living.level().getBlockState(pos);
        if (this.canBreak((LivingEntity)this.living, state, pos, item, itemOff)) {
            this.breakIndex = 0;
            return pos;
        }
        ++this.breakIndex;
        if (this.breakIndex == this.breakAOE.size()) {
            this.breakIndex = 0;
        }
        return null;
    }

    private boolean canBreak(LivingEntity entity, BlockState state, BlockPos pos, ItemStack item, ItemStack itemOff) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (BlockGetter)entity.level(), (Entity)entity, CollisionContext.of((Entity)entity)) && (Utils.canHarvest(state, item) || Utils.canHarvest(state, itemOff));
    }

    private boolean aboveTarget() {
        return this.target.getY() < this.living.getY() + 1.1;
    }

    public static Rotation getDigDirection(Mob mob) {
        Path path = mob.getNavigation().getPath();
        if (path != null) {
            Node point;
            Node node = point = path.getNextNodeIndex() < path.getNodeCount() ? path.getNextNode() : null;
            if (point != null) {
                Vec3 dir = new Vec3((double)point.x + 0.5, mob.position().y, (double)point.z + 0.5).subtract(mob.position());
                if (Math.abs(dir.x) < Math.abs(dir.z)) {
                    if (dir.z >= 0.0) {
                        return Rotation.NONE;
                    }
                    return Rotation.CLOCKWISE_180;
                }
                if (dir.x > 0.0) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                return Rotation.CLOCKWISE_90;
            }
        }
        return switch (mob.getDirection()) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }
}

