/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.events;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.DifficultyFeatures;
import io.github.flemmli97.improvedmobs.api.datapack.EntityOverridesManager;
import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.common.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.common.entities.ai.BlockBreakGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.FlyRidingGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.ItemUseGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.LadderClimbGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.StealGoal;
import io.github.flemmli97.improvedmobs.common.entities.ai.WaterRidingGoal;
import io.github.flemmli97.improvedmobs.common.network.PacketHandler;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import io.github.flemmli97.improvedmobs.common.utils.BlockRestorationData;
import io.github.flemmli97.improvedmobs.common.utils.ContainerOpened;
import io.github.flemmli97.improvedmobs.common.utils.EntityFlags;
import io.github.flemmli97.improvedmobs.common.utils.Utils;
import io.github.flemmli97.improvedmobs.mixin.MobEntityMixin;
import io.github.flemmli97.improvedmobs.mixin.NearestTargetGoalMixin;
import io.github.flemmli97.improvedmobs.mixin.TargetGoalAccessor;
import io.github.flemmli97.improvedmobs.mixinhelper.EntitySpawnReason;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EventCalls {
    public static void levelJoin(ServerPlayer player, MinecraftServer server) {
        CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createDifficultyPacket(DifficultyData.get(server), player), player);
        CrossPlatformStuff.INSTANCE.sendClientboundPacket(PacketHandler.createConfigPacket(), player);
    }

    public static void tick(ServerLevel level) {
        BlockRestorationData.get(level).tick(level);
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        if (!Config.CommonConfig.enableDifficultyScaling) {
            DifficultyData.get(level.getServer()).updateTime(level.getServer());
            return;
        }
        if (!Config.CommonConfig.difficultyType.increaseDifficulty) {
            if (level.getGameTime() % 20L == 0L) {
                CrossPlatformStuff.INSTANCE.sendDifficultyData(DifficultyData.get(level.getServer()), level.getServer());
                DifficultyData.get(level.getServer()).updateTime(level.getServer());
            }
            return;
        }
        boolean shouldIncrease = (Config.CommonConfig.ignorePlayers || !level.getServer().getPlayerList().getPlayers().isEmpty()) && level.getDayTime() > (long)Config.CommonConfig.difficultyDelay;
        DifficultyData data = DifficultyData.get(level.getServer());
        long timeDiff = Math.abs(level.getDayTime() - data.getPrevTime());
        if (Config.CommonConfig.considerTimeskip) {
            if (timeDiff > 2400L) {
                long i = timeDiff / 2400L;
                if (timeDiff - i * 2400L > (i + 1L) * 2400L - timeDiff) {
                    ++i;
                }
                while (i > 0L) {
                    data.increaseDifficulty(shouldIncrease, level.getDayTime(), level.getServer());
                    --i;
                }
            }
        } else if (timeDiff > 2400L) {
            data.increaseDifficulty(shouldIncrease, level.getDayTime(), level.getServer());
        }
    }

    public static void onEntityLoad(Mob mob) {
        Predicate<EntityType<?>> targets;
        boolean hasVillagerTarget;
        boolean aggressive;
        boolean ignoreSight;
        if (mob.level().isClientSide || mob instanceof RiddenSummonEntity) {
            return;
        }
        if (((EntitySpawnReason)mob).improvedMobs$getSpawnReason() == MobSpawnType.SPAWNER && Config.CommonConfig.ignoreSpawner) {
            return;
        }
        EntityFlags flags = EntityFlags.get((Entity)mob);
        boolean mobGriefing = mob.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        double difficulty = DifficultyData.getDifficulty(mob.level(), (LivingEntity)mob);
        VariableMap map = Config.create((LivingEntity)mob, difficulty);
        if (flags.canBreakBlocks == EntityFlags.FlagType.UNDEFINED) {
            flags.canBreakBlocks = difficulty >= (double)Config.CommonConfig.difficultyBreak && (double)mob.getRandom().nextFloat() < Config.CommonConfig.breakerChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.BLOCKBREAK) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        if (flags.canFly == EntityFlags.FlagType.UNDEFINED) {
            flags.canFly = (double)mob.getRandom().nextFloat() < Config.CommonConfig.flyAIChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.FLYING) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        EventCalls.applyAttributesAndItems(mob, difficulty, map);
        if (!Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.USEITEM)) {
            mob.goalSelector.addGoal(-1, (Goal)new ItemUseGoal(mob));
        }
        if ((double)mob.getRandom().nextFloat() < Config.CommonConfig.guardianAIChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.GUARDIAN)) {
            mob.goalSelector.addGoal(6, (Goal)new WaterRidingGoal(mob));
        }
        if (flags.canFly == EntityFlags.FlagType.TRUE) {
            mob.goalSelector.addGoal(6, (Goal)new FlyRidingGoal(mob));
            if (!(((MobEntityMixin)mob).getTrueNavigator() instanceof FlyingPathNavigation) && !(mob instanceof Slime)) {
                mob.goalSelector.addGoal(6, (Goal)new FlyRidingGoal(mob));
            }
        }
        if (!Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.LADDER) && !(mob.getNavigation() instanceof WallClimberNavigation)) {
            EntityFlags.get((Entity)mob).ladderClimber = true;
            mob.goalSelector.addGoal(4, (Goal)new LadderClimbGoal(mob));
        }
        boolean villager = !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.TARGETVILLAGER);
        boolean bl = ignoreSight = (double)mob.getRandom().nextFloat() < Config.CommonConfig.ignoreSightChance.get(map);
        if (mob instanceof NeutralMob && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.NEUTRALAGGRO)) {
            boolean bl2 = aggressive = (double)mob.getRandom().nextFloat() < Config.CommonConfig.neutralAggressiv.get(map);
            if (aggressive) {
                mob.targetSelector.addGoal(1, EventCalls.setNoLoS(mob, Player.class, ignoreSight, null));
            }
        } else {
            aggressive = true;
        }
        if (villager && aggressive && !(hasVillagerTarget = mob.targetSelector.getAvailableGoals().stream().anyMatch(g -> {
            NearestTargetGoalMixin target;
            Goal patt0$temp;
            return g != null && (patt0$temp = g.getGoal()) instanceof NearestTargetGoalMixin && (target = (NearestTargetGoalMixin)patt0$temp).targetTypeClss() == AbstractVillager.class;
        }))) {
            mob.targetSelector.addGoal(3, EventCalls.setNoLoS(mob, AbstractVillager.class, ignoreSight, null));
        }
        if ((targets = Config.CommonConfig.autoTargets.get(mob.getType())) != null) {
            mob.targetSelector.addGoal(3, EventCalls.setNoLoS(mob, LivingEntity.class, ignoreSight, l -> targets.test(l.getType())));
        }
        if (mob instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            if (difficulty >= (double)Config.CommonConfig.difficultySteal && mobGriefing && (double)mob.getRandom().nextFloat() < Config.CommonConfig.stealerChance.get(map) && !Config.CommonConfig.entityBlacklist.isDisabledFor(mob, DifficultyFeatures.STEAL)) {
                pathfinderMob.goalSelector.addGoal(5, (Goal)new StealGoal(pathfinderMob));
            }
        }
        if (flags.canBreakBlocks == EntityFlags.FlagType.TRUE) {
            mob.targetSelector.getAvailableGoals().forEach(g -> {
                if (g != null && g.getGoal() instanceof NearestAttackableTargetGoal && mob.getRandom().nextFloat() < Config.CommonConfig.breakerSightIgnore) {
                    ((TargetGoalAccessor)g.getGoal()).setShouldCheckSight(false);
                    ((NearestTargetGoalMixin)g.getGoal()).getTargetEntitySelector().ignoreLineOfSight();
                }
            });
            if (mobGriefing) {
                mob.goalSelector.addGoal(1, (Goal)new BlockBreakGoal(mob));
                if (mob.getOffhandItem().isEmpty()) {
                    ItemStack stack = Config.CommonConfig.getRandomBreakingItem(mob.getRandom());
                    mob.setDropChance(EquipmentSlot.OFFHAND, (float)Config.CommonConfig.dropChance.get(map));
                    mob.setItemSlot(EquipmentSlot.OFFHAND, stack);
                }
            }
        }
    }

    private static <T extends LivingEntity> NearestAttackableTargetGoal<T> setNoLoS(Mob e, Class<T> clss, boolean ignoreSight, Predicate<LivingEntity> pred) {
        NearestAttackableTargetGoal goal = pred == null ? new NearestAttackableTargetGoal(e, clss, !ignoreSight) : new NearestAttackableTargetGoal(e, clss, 10, !ignoreSight, false, pred);
        if (ignoreSight) {
            ((NearestTargetGoalMixin)goal).getTargetEntitySelector().ignoreLineOfSight();
        }
        return goal;
    }

    private static void applyAttributesAndItems(Mob living, double difficulty, VariableMap map) {
        EntityFlags flags = EntityFlags.get((Entity)living);
        if (!flags.modifyArmor) {
            if (!Config.CommonConfig.entityBlacklist.isDisabledFor(living, DifficultyFeatures.ARMOR)) {
                Utils.equipArmor(living, difficulty, map);
            }
            flags.modifyArmor = true;
        }
        if (!flags.modifyHeldItems) {
            if (!Config.CommonConfig.entityBlacklist.isDisabledFor(living, DifficultyFeatures.HELDITEMS)) {
                Utils.equipHeld(living, difficulty, map);
            }
            flags.modifyHeldItems = true;
        }
        if (!flags.enchantGear) {
            Utils.enchantGear(living, difficulty, map);
            flags.enchantGear = true;
        }
        if (!flags.modifyAttributes) {
            if (!Config.CommonConfig.entityBlacklist.isDisabledFor(living, DifficultyFeatures.ATTRIBUTES)) {
                EntityOverridesManager.getInstance().applyAttributesTo((LivingEntity)living, map);
            }
            flags.modifyAttributes = true;
        }
    }

    public static float hurtEvent(LivingEntity entity, DamageSource source, float dmg) {
        if (source.is(DamageTypeTags.IS_PROJECTILE) && source.getEntity() instanceof Monster) {
            return (float)((double)dmg * EntityFlags.get(source.getEntity()).getAttribute(EntityFlags.ServerSideAttributes.PROJECTILE_DAMAGE_MULTIPLIER));
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION) && source.getEntity() instanceof Monster) {
            return (float)((double)dmg * EntityFlags.get(source.getEntity()).getAttribute(EntityFlags.ServerSideAttributes.EXPLOSION_DAMAGE_MULTIPLIER));
        }
        if (entity instanceof Monster && source.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
            return (float)((double)dmg * (1.0 - EntityFlags.get((Entity)entity).getAttribute(EntityFlags.ServerSideAttributes.MAGIC_RESISTANCE)));
        }
        return dmg;
    }

    public static boolean onAttackEvent(LivingEntity target, DamageSource damagesource) {
        if (!target.level().isClientSide) {
            LivingEntity attacker;
            if (!Config.CommonConfig.friendlyFire && target instanceof TamableAnimal) {
                TamableAnimal pet = (TamableAnimal)target;
                if (damagesource.getEntity() != null && damagesource.getEntity() == pet.getOwner() && !damagesource.getEntity().isShiftKeyDown()) {
                    return true;
                }
            }
            Entity source = damagesource.getEntity();
            if (target instanceof Player) {
                Entity direct = damagesource.getDirectEntity();
                if (direct instanceof Snowball) {
                    EntityFlags flag = EntityFlags.get(direct);
                    if (flag.isThrownEntity) {
                        flag.isThrownEntity = false;
                        target.hurt(damagesource, 0.001f);
                    }
                }
            } else if (source instanceof LivingEntity && CrossPlatformStuff.INSTANCE.canDisableShield((attacker = (LivingEntity)source).getMainHandItem(), target.getUseItem(), target, attacker)) {
                EventCalls.triggerDisableShield(target);
            }
        }
        return false;
    }

    private static void triggerDisableShield(LivingEntity target) {
        EntityFlags.get((Entity)target).disableShield();
        target.stopUsingItem();
        target.level().broadcastEntityEvent((Entity)target, (byte)30);
    }

    public static void openTile(Player player, BlockPos pos) {
        BlockEntity blockEntity;
        if (!player.level().isClientSide && !player.isShiftKeyDown() && (blockEntity = player.level().getBlockEntity(pos)) != null) {
            ((ContainerOpened)ImprovedMobsAttachments.HAS_BEEN_OPENED.get().get((Object)blockEntity)).setOpened(blockEntity);
        }
    }

    public static boolean equipPet(Player player, InteractionHand hand, Entity target) {
        ItemStack heldItem;
        Item item;
        OwnableEntity pet;
        Mob mob;
        if (hand == InteractionHand.MAIN_HAND && target instanceof Mob && ((mob = (Mob)target) instanceof OwnableEntity || mob.getType().is(ImprovedMobs.ARMOR_EQUIPPABLE)) && !target.level().isClientSide && player.isShiftKeyDown() && !Utils.isInList(target, Config.CommonConfig.petArmorBlackList, Config.CommonConfig.petWhiteList, Utils.ENTITY_ID) && (!(mob instanceof OwnableEntity) || player == (pet = (OwnableEntity)mob).getOwner()) && (item = (heldItem = player.getMainHandItem()).getItem()) instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            EquipmentSlot type = armor.getEquipmentSlot();
            switch (type) {
                case HEAD: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.HEAD);
                    break;
                }
                case CHEST: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.CHEST);
                    break;
                }
                case LEGS: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.LEGS);
                    break;
                }
                case FEET: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.FEET);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static void equipPetItem(Player player, Mob living, ItemStack stack, EquipmentSlot slot) {
        ItemStack current = living.getItemBySlot(slot);
        if (!current.isEmpty() && !player.isCreative()) {
            ItemEntity entityitem = new ItemEntity(living.level(), living.getX(), living.getY(), living.getZ(), current);
            entityitem.setNoPickUpDelay();
            living.level().addFreshEntity((Entity)entityitem);
        }
        ItemStack copy = stack.copy();
        copy.setCount(1);
        living.setItemSlot(slot, copy);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
    }

    public static boolean projectileImpact(Projectile projectile, HitResult hitResult) {
        EntityHitResult res;
        Entity thrower;
        return EntityFlags.get((Entity)projectile).isThrownEntity && (thrower = projectile.getOwner()) instanceof Mob && !(projectile instanceof ThrownPotion) && hitResult.getType() == HitResult.Type.ENTITY && !(res = (EntityHitResult)hitResult).getEntity().equals((Object)((Mob)thrower).getTarget());
    }

    public static void explosion(Explosion explosion, Entity source, List<Entity> affectedEntities) {
        if (source instanceof PrimedTnt && EntityFlags.get((Entity)source).isThrownEntity) {
            LivingEntity igniter;
            if (!Config.CommonConfig.tntBlockDestruction) {
                explosion.getToBlow().clear();
            }
            if ((igniter = explosion.getIndirectSourceEntity()) instanceof Mob) {
                affectedEntities.removeIf(e -> !e.equals((Object)((Mob)igniter).getTarget()));
            }
        }
    }

    public static void onTagReloaded() {
        Config.CommonConfig.breakableBlocks.tagReloaded();
        Config.CommonConfig.autoTargets.tagReloaded();
        Config.CommonConfig.entityBlacklist.tagReloaded();
    }
}

