/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.common.utils;

import io.github.flemmli97.improvedmobs.common.config.Config;
import io.github.flemmli97.improvedmobs.common.utils.CustomBlockCollision;
import io.github.flemmli97.improvedmobs.common.utils.Utils;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PathFindingUtils {
    public static Node handleBreakableNode(Mob mob, BlockGetter getter, int x, int y, int z, Direction dir, Node origin, Function<AABB, Boolean> collision, Function<AABB, Boolean> collisionDefault, Function<BlockPos, Node> nodeGetter) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        AABB aabb = PathFindingUtils.createAABBForPos(getter, x, y, z, (double)mob.getBbWidth() / 2.0, mob.getBbHeight());
        boolean defaultCollides = collisionDefault.apply(aabb.expandTowards((double)(-dir.getStepX()), 0.0, (double)(-dir.getStepZ())));
        if (!defaultCollides) {
            return null;
        }
        boolean breakableCollides = collision.apply(aabb.expandTowards((double)(-dir.getStepX()), 0.0, (double)(-dir.getStepZ())));
        if (!breakableCollides) {
            if (origin.y != y) {
                pos.set(x, origin.y, z);
            }
            return nodeGetter.apply((BlockPos)pos);
        }
        return null;
    }

    public static boolean noCollision(CollisionGetter level, LivingEntity entity, AABB aABB, boolean breakable, boolean ladder) {
        Iterable shapes = () -> new CustomBlockCollision(level, entity, aABB, breakable, ladder);
        for (VoxelShape voxelShape : shapes) {
            if (voxelShape.isEmpty()) continue;
            return false;
        }
        if (entity != null) {
            WorldBorder worldBorder = level.getWorldBorder();
            VoxelShape voxelShape2 = worldBorder.isInsideCloseToBorder((Entity)entity, aABB) ? worldBorder.getCollisionShape() : null;
            return voxelShape2 == null || !Shapes.joinIsNotEmpty((VoxelShape)voxelShape2, (VoxelShape)Shapes.create((AABB)aABB), (BooleanOp)BooleanOp.AND);
        }
        return true;
    }

    public static AABB createAABBForPos(int x, int y, int z, double widthHalf, double height) {
        return new AABB((double)x - widthHalf + 0.5, (double)y, (double)z - widthHalf + 0.5, (double)x + widthHalf + 0.5, (double)y + height, (double)z + widthHalf + 0.5);
    }

    public static AABB createAABBForPos(BlockGetter getter, int x, int y, int z, double widthHalf, double height) {
        double floor1 = WalkNodeEvaluator.getFloorLevel((BlockGetter)getter, (BlockPos)new BlockPos(x, y + 1, z));
        return new AABB((double)x - widthHalf + 0.5, floor1 + 0.001, (double)z - widthHalf + 0.5, (double)x + widthHalf + 0.5, height + floor1, (double)z + widthHalf + 0.5);
    }

    public static int createLadderNodeFor(int nodeID, Node[] nodes, Node origin, Function<BlockPos, Node> nodeGetter, Mob mob, Long2BooleanMap cache) {
        Node node;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin.x, origin.y + 1, origin.z);
        if (cache.computeIfAbsent(pos.asLong(), l -> {
            BlockState state = mob.level().getBlockState((BlockPos)pos);
            return CrossPlatformStuff.INSTANCE.isClimbable(state, (LivingEntity)mob, (BlockPos)pos);
        }) && (node = nodeGetter.apply((BlockPos)pos)) != null && !node.closed && nodeID + 1 < nodes.length) {
            nodes[nodeID++] = node;
        }
        pos.set(pos.getX(), pos.getY() - 1, pos.getZ());
        if (cache.computeIfAbsent(pos.asLong(), l -> {
            BlockState state = mob.level().getBlockState((BlockPos)pos);
            return CrossPlatformStuff.INSTANCE.isClimbable(state, (LivingEntity)mob, (BlockPos)pos);
        }) && (node = nodeGetter.apply((BlockPos)pos)) != null && !node.closed && nodeID + 1 < nodes.length) {
            nodes[nodeID++] = node;
        }
        return nodeID;
    }

    public static int createBreakableNodeBelow(int nodeID, Node[] nodes, Node origin, Function<BlockPos, Node> nodeGetter, Mob mob, Long2BooleanMap cache) {
        Node node;
        BlockPos pos = new BlockPos(origin.x, origin.y - 1, origin.z);
        if (cache.computeIfAbsent(pos.asLong(), l -> {
            BlockState state = mob.level().getBlockState(pos);
            return PathFindingUtils.canBreak(state, pos, mob);
        }) && (node = nodeGetter.apply(pos)) != null && !node.closed && nodeID + 1 < nodes.length) {
            nodes[nodeID++] = node;
        }
        return nodeID;
    }

    public static boolean canBreak(BlockState state, BlockPos pos, Mob entity) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (BlockGetter)entity.level(), (Entity)entity, CollisionContext.of((Entity)entity)) && (Utils.canHarvest(state, entity.getMainHandItem()) || Utils.canHarvest(state, entity.getOffhandItem()));
    }
}

