/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.mixin;

import io.github.flemmli97.improvedmobs.mixinhelper.LivingSensingExt;
import io.github.flemmli97.improvedmobs.mixinhelper.SensingExt;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.sensing.Sensing;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sensing.class})
public abstract class EntitySensingMixin
implements SensingExt {
    @Final
    @Shadow
    private Mob mob;
    @Unique
    private final IntSet improvedmobs$seen = new IntOpenHashSet();
    @Unique
    private final IntSet improvedmobs$unseen = new IntOpenHashSet();
    @Unique
    private boolean improvedmobs$extended_los;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo info) {
        this.improvedmobs$seen.clear();
        this.improvedmobs$unseen.clear();
    }

    @Inject(method={"hasLineOfSight"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHasLoS(Entity entity, CallbackInfoReturnable<Boolean> info) {
        if (this.improvedmobs$extended_los) {
            info.setReturnValue((Object)this.hasLineOfSightExt(entity));
            this.improvedmobs$extended_los = false;
        }
    }

    private boolean hasLineOfSightExt(Entity entity) {
        int i = entity.getId();
        if (this.improvedmobs$seen.contains(i)) {
            return true;
        }
        if (this.improvedmobs$unseen.contains(i)) {
            return false;
        }
        this.mob.level().getProfiler().push("hasLineOfSight");
        ((LivingSensingExt)this.mob).improvedMobs$doExtendedLOSCheck();
        boolean bl = this.mob.hasLineOfSight(entity);
        this.mob.level().getProfiler().pop();
        if (bl) {
            this.improvedmobs$seen.add(i);
        } else {
            this.improvedmobs$unseen.add(i);
        }
        return bl;
    }

    @Override
    public void improvedMobs$doLineOfSightExt() {
        this.improvedmobs$extended_los = true;
    }
}

