/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.neoforge;

import io.github.flemmli97.improvedmobs.api.datapack.EntityOverridesManager;
import io.github.flemmli97.improvedmobs.api.datapack.ItemUseLookupManager;
import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyFetcher;
import io.github.flemmli97.improvedmobs.api.item.ItemUseRegistry;
import io.github.flemmli97.improvedmobs.common.config.holder.ConfigLoader;
import io.github.flemmli97.improvedmobs.common.config.holder.ConfigSpecs;
import io.github.flemmli97.improvedmobs.common.datapack.DifficultyAttributeConfig;
import io.github.flemmli97.improvedmobs.common.network.S2CDiffcultyValue;
import io.github.flemmli97.improvedmobs.common.network.S2CShowDifficulty;
import io.github.flemmli97.improvedmobs.common.registry.ImprovedMobsAttachments;
import io.github.flemmli97.improvedmobs.neoforge.AttachmentsRegister;
import io.github.flemmli97.improvedmobs.neoforge.client.ClientEventHandler;
import io.github.flemmli97.improvedmobs.neoforge.events.DifficultyHandler;
import io.github.flemmli97.improvedmobs.neoforge.events.EventHandler;
import io.github.flemmli97.improvedmobs.neoforge.integration.difficulty.ScalingHealthDifficulty;
import java.io.File;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="improvedmobs")
public class ImprovedMobsNeoForge {
    public ImprovedMobsNeoForge(IEventBus modBus) {
        ImprovedMobsAttachments.ATTACHMENTS.registerContent();
        File file = FMLPaths.CONFIGDIR.get().resolve("improvedmobs").toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, ConfigSpecs.CLIENT_SPEC, "improvedmobs/client.toml");
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, ConfigSpecs.COMMON_SPEC, "improvedmobs/common.toml");
        modBus.addListener(ImprovedMobsNeoForge::setup);
        modBus.addListener(ImprovedMobsNeoForge::conf);
        modBus.addListener(ImprovedMobsNeoForge::registerPackets);
        AttachmentsRegister.ATTACHMENT_TYPES.register(modBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.setup(modBus);
        }
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
        NeoForge.EVENT_BUS.addListener(ImprovedMobsNeoForge::addReloadListener);
        ItemUseRegistry.initBuiltin();
        DifficultyFetcher.register();
        if (ModList.get().isLoaded("scalinghealth")) {
            DifficultyFetcher.add(ResourceLocation.fromNamespaceAndPath((String)"improvedmobs", (String)"scalinghealth_integration"), new ScalingHealthDifficulty());
        }
    }

    static void setup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new DifficultyHandler());
    }

    static void conf(ModConfigEvent event) {
        if (event.getConfig().getSpec() == ConfigSpecs.CLIENT_SPEC) {
            ConfigLoader.loadClient();
        } else if (event.getConfig().getSpec() == ConfigSpecs.COMMON_SPEC) {
            ConfigLoader.loadCommon();
        }
    }

    static void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("improvedmobs").optional();
        registrar.playToClient(S2CDiffcultyValue.TYPE, S2CDiffcultyValue.STREAM_CODEC, (pkt, ctx) -> S2CDiffcultyValue.handle(pkt));
        registrar.playToClient(S2CShowDifficulty.TYPE, S2CShowDifficulty.STREAM_CODEC, (pkt, ctx) -> S2CShowDifficulty.handle(pkt));
    }

    static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)DifficultyAttributeConfig.create(event.getServerResources().getRegistryLookup()));
        event.addListener((PreparableReloadListener)EntityOverridesManager.create(event.getServerResources().getRegistryLookup()));
        event.addListener((PreparableReloadListener)ItemUseLookupManager.create(event.getServerResources().getRegistryLookup()));
    }
}

