/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.api.DifficultyFeatures;
import io.github.flemmli97.improvedmobs.api.datapack.EntityConfigProperties;
import io.github.flemmli97.improvedmobs.common.datapack.DifficultyAttributeConfig;
import io.github.flemmli97.improvedmobs.common.datapack.SingleFileResources;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EntityOverridesManager
extends SimpleJsonResourceReloadListener {
    public static final ResourceLocation ID = ImprovedMobs.modRes("entity_configs");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private static EntityOverridesManager INSTANCE;
    private final HolderLookup.Provider provider;
    private Set<EntityConfigProperties> unresolved = ImmutableSet.of();
    private boolean resolved;
    private Map<EntityType<?>, EntityConfigProperties> properties = ImmutableMap.of();

    private EntityOverridesManager(HolderLookup.Provider provider) {
        super(SingleFileResources.GSON, DIRECTORY);
        this.provider = provider;
    }

    public static EntityOverridesManager create(HolderLookup.Provider provider) {
        INSTANCE = new EntityOverridesManager(provider);
        return EntityOverridesManager.getInstance();
    }

    public static EntityOverridesManager getInstance() {
        return INSTANCE;
    }

    public void applyAttributesTo(LivingEntity entity, VariableMap map) {
        this.resolve();
        EntityConfigProperties properties = this.properties.get(entity.getType());
        if (properties != null) {
            if (properties.attributes().replace()) {
                properties.attributes().val().apply(entity, map, null);
            } else {
                DifficultyAttributeConfig.getInstance().config().apply(entity, map, properties.attributes().val());
            }
        } else {
            DifficultyAttributeConfig.getInstance().config().apply(entity, map, null);
        }
    }

    public OverrideState isEnabled(LivingEntity entity, DifficultyFeatures feature) {
        this.resolve();
        EntityConfigProperties properties = this.properties.get(entity.getType());
        if (properties == null || properties.enabledFeatures().isEmpty()) {
            return OverrideState.DEFAULT;
        }
        EnumSet<DifficultyFeatures> set = properties.enabledFeatures().get();
        return set.contains((Object)DifficultyFeatures.REVERSE) ^ (set.contains((Object)DifficultyFeatures.ALL) || set.contains((Object)feature)) ? OverrideState.ALLOW : OverrideState.DENY;
    }

    public OverrideState canBreak(LivingEntity entity, BlockState state) {
        this.resolve();
        EntityConfigProperties properties = this.properties.get(entity.getType());
        if (properties == null) {
            return OverrideState.DEFAULT;
        }
        if (properties.breakableBlocks().val().contains(state.getBlockHolder())) {
            return OverrideState.ALLOW;
        }
        return properties.breakableBlocks().replace() ? OverrideState.DENY : OverrideState.DEFAULT;
    }

    public void resolve() {
        if (!this.resolved) {
            this.resolved = true;
            HashMap direct = new HashMap();
            HashMap<EntityType, EntityConfigProperties> tags = new HashMap<EntityType, EntityConfigProperties>();
            HashMap<EntityType, EntityConfigProperties> namespace = new HashMap<EntityType, EntityConfigProperties>();
            BuiltInRegistries.ENTITY_TYPE.holders().forEach(type -> this.unresolved.forEach(props -> {
                if (props.type().isDirect((Holder<EntityType<?>>)type)) {
                    direct.put((EntityType)type.value(), props);
                }
                if (props.type().isTag((Holder<EntityType<?>>)type)) {
                    tags.put((EntityType)type.value(), (EntityConfigProperties)props);
                }
                if (props.type().isNamespace((Holder<EntityType<?>>)type)) {
                    namespace.put((EntityType)type.value(), (EntityConfigProperties)props);
                }
            }));
            tags.forEach((type, prop) -> {
                if (!direct.containsKey(type)) {
                    direct.put(type, prop);
                }
            });
            namespace.forEach((type, prop) -> {
                if (!direct.containsKey(type)) {
                    direct.put(type, prop);
                }
            });
            this.properties = ImmutableMap.copyOf(direct);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.resolved = false;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        HashSet overrides = new HashSet();
        data.forEach((arg_0, arg_1) -> EntityOverridesManager.lambda$apply$4(builder, (DynamicOps)ops, overrides, arg_0, arg_1));
        if (!overrides.isEmpty()) {
            ImprovedMobs.LOGGER.info("Following entity overrides are loaded: {}", overrides);
        }
        this.unresolved = builder.build();
    }

    private static /* synthetic */ void lambda$apply$4(ImmutableSet.Builder builder, DynamicOps ops, Set overrides, ResourceLocation res, JsonElement element) {
        try {
            builder.add((Object)((EntityConfigProperties)EntityConfigProperties.CODEC.parse(ops, (Object)element).getOrThrow()));
            overrides.add(res);
        }
        catch (Exception ex) {
            ImprovedMobs.LOGGER.error("Couldn't parse entity config json {} {}", (Object)res, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }

    public static enum OverrideState {
        DEFAULT,
        ALLOW,
        DENY;

    }
}

